#!/usr/bin/env perl
# generate cp932 mapping table
# Copyright (C) 2006  MIRACLE LINUX CORPORATION.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

use File::Basename;

$MAPDIR = dirname($0);

# ftp://ftp.unicode.org/Public/MAPPINGS/VENDORS/MICSFT/WINDOWS/CP932.TXT
$CP932TXT = "CP932.TXT";

$private_use_area = 1;

($SJIS, $UNI, $COM, $FB) = (0 .. 3);

sub make_private_area_mapping {
    my ($before, $current) = @_;
    my ($c1, $c2, $u, $ret);

    $ret = 1;
    if ($before < 0xE000 && $current >= 0xF900) {
	for ($c1 = 0xF0; $c1 <= 0xF9; $c1++) {
	    for ($c2 = 0x40; $c2 <= 0xFC; $c2++) {
		if ($c2 == 0x7F) { next; }
		$u = ($c1 - 0xF0) * 188 + ($c2 - 0x40 - (0x7F<=$c2)) + 0xE000;
		printf("<U%04X> \\x%02X\\x%02X |0 # PRIVATE USE AREA\n", 
		       $u, $c1, $c2);
	    }
	}
	$ret = 0;
    }
    return $ret;
}

if ($#ARGV > -1) {
    open(F, $ARGV[0]) or die;
} else {
    open(F, "$MAPDIR/$CP932TXT") or die;
}
while (<F>) {
    if ($_ =~ /^#/) { next; }
    ($sjis, $uni, $com) = split(/\t+/, $_);
    if ($uni =~ /^ +/) { next; }

    $uni = hex(substr($uni, 2, 4));
    $sjis = hex(substr($sjis, 2));
    chomp($com);
    push(@tbl, [$sjis, $uni, $com, 0]);

    if ($sjis >= 0x00 && $sjis <= 0xFF
	|| $sjis >= 0x8140 && $sjis <= 0x84FC
	|| $sjis >= 0x889F && $sjis <= 0xEAFC) {
	$u2s{$uni} = $sjis;
    } elsif (!defined($u2s{$uni})
             && ($sjis >= 0x8740 && $sjis <= 0x879E
             ||  $sjis >= 0xFA40 && $sjis <= 0xFC9E)) {
	$u2s{$uni} = $sjis;
    } else {
	$tbl[$#tbl][$FB] = 3;
    }
}
close(F);

@tbl = sort
{
    if ($a->[$UNI] == $b->[$UNI]) {
	if ($u2s{$a->[$UNI]} == $a->[$SJIS]) {
	    -1;
	} else {
	    1;
	}
    } elsif ($a->[$UNI] > $b->[$UNI]) {
	1;
    } else {
	-1;
    }
} @tbl;

print <<'END';
<code_set_name> "cp932"
<mb_cur_min> 1
<mb_cur_max> 2
<subchar> \x3F
CHARMAP
END

$before = 0;
for ($i = 0; $i <= $#tbl; $i++) {
    $u   = $tbl[$i][$UNI];
    $c1  = ($tbl[$i][$SJIS] >> 8) & 0xFF;
    $c2  = $tbl[$i][$SJIS] & 0xFF;
    $fb  = $tbl[$i][$FB];
    $com = substr($tbl[$i][$COM], 1);

    if ($private_use_area) {
	$private_use_area = &make_private_area_mapping($before, $u);
    }
    if ($tbl[$i][$SJIS] <= 0xFF) {
	printf("<U%04X> \\x%02X |%d # %s\n", $u, $c2, $fb, $com);
    } else {
	printf("<U%04X> \\x%02X\\x%02X |%d # %s\n", $u, $c1, $c2, $fb, $com);
    }
    $before = $u;
}
print "END CHARMAP\n";
