#!/usr/bin/perl

my ($MB, $UCS, $COM, $FB) = (0 .. 3);
my ($mb_cur_min, $mb_cur_max) = (256, 1);

my $ESC_ASCII='\\\\x1B\\\\x28\\\\x42';
my $ESC_JISX0201_LATIN='\\\\x1B\\\\x28\\\\x4A';
my $ESC_JISX0201_KANA='\\\\x1B\\\\x28\\\\x49';
my $ESC_JISX0208_1978='\\\\x1B\\\\x24\\\\x40';
my $ESC_JISX0208_1983='\\\\x1B\\\\x24\\\\x42';
my $ESC_UDC='\\\\x1B\\\\x24\\\\x28\\\\x3F';

while (<>) {
	if ($_ =~ /^#/) { next; }
	chomp($_);

	$_ =~ s/($ESC_ASCII|$ESC_JISX0201_LATIN|$ESC_JISX0201_KANA|$ESC_JISX0208_1978|$ESC_JISX0208_1983|$ESC_UDC)//g;
	$_ =~ s/\\x0E(.*)\\x0F/$1/g;
	$_ =~ s/^<U3000>(<U[0-9A-F]*>)([\t ]+)\\x21\\x21((?:\\x[0-9A-F])+?)/$1$2$3/g;

	if ($_ =~ /^<U/) {
		($ucs, $mb) = split(/[\t ]+/, $_);
		$ucs2mb{$ucs} = $mb;
	} elsif ($_ =~ /^\\x/) {
		($mb, $ucs) = split(/[\t ]+/, $_);
		$mb2ucs{$mb} = $ucs;
	}
        my $len = length($mb) / 4;
        $mb_cur_min = $len if ($len > 0 && $mb_cur_min > $len);
        $mb_cur_max = $len if ($len > 0 && $mb_cur_min < $len);
}

foreach $ucs (sort keys %ucs2mb) {
	$mb = $ucs2mb{$ucs};
	if (defined($mb2ucs{$mb})) {
		if ($mb2ucs{$mb} eq $ucs) {
			$fb = 0;
		} else {
			$fb = 1;
		}
	} else {
		$fb = 1;
	}
	push(@tbl, [$mb, $ucs, "", $fb]);
}

foreach $mb (sort keys %mb2ucs) {
	$ucs = $mb2ucs{$mb};
	if (defined($ucs2mb{$ucs})) {
		if ($ucs2mb{$ucs} eq $mb) {
			next;
		} else {
			$fb = 3;
		}
	} else {
		$fb = 3;
	}
	push(@tbl, [$mb, $ucs, "", $fb]);
}

my @tbl = sort
{
	if ($a->[$UCS] eq $b->[$UCS]) {
		if ($ucs2mb{$a->[$UCS]} eq $a->[$MB]) {
			-1;
		} else {
			if ($a->[$MB] gt $b->[$MB]) {
				1;
			} else {
				0
			}
		}
	} elsif ($a->[$UCS] gt $b->[$UCS]) {
		1;
	} else {
		-1;
	}
} @tbl;

print <<"END";
<mb_cur_min> $mb_cur_min
<mb_cur_max> $mb_cur_max
CHARMAP
END

for ($i = 0; $i <= $#tbl; $i++) {
	print "$tbl[$i][$UCS] $tbl[$i][$MB] |$tbl[$i][$FB]\n";
}
print "END CHARMAP\n";

