/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.lepidolite.dao;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import jp.sourceforge.lepidolite.dao.ConnectionProxy;
import jp.sourceforge.lepidolite.dao.DaoException;
import jp.sourceforge.lepidolite.dao.DaoSettings;
import jp.sourceforge.lepidolite.dao.DaoTransaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcDaoTransaction
implements DaoTransaction {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private Connection conn;
    private String owner;

    JdbcDaoTransaction() {
        try {
            Class.forName(DaoSettings.getJdbcDriver());
            this.conn = DriverManager.getConnection(DaoSettings.getJdbcUrl(), DaoSettings.getJdbcUsername(), DaoSettings.getJdbcPassword());
            this.conn = ConnectionProxy.createProxy(this.conn);
            this.conn.setAutoCommit(false);
        }
        catch (ClassNotFoundException cnfe) {
            throw new DaoException("JDBC\u30c9\u30e9\u30a4\u30d0\u30af\u30e9\u30b9 '" + DaoSettings.getJdbcDriver() + "' \u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093", cnfe);
        }
        catch (SQLException sqle) {
            throw new DaoException("\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u30a2\u30af\u30bb\u30b9\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002", sqle);
        }
    }

    public Connection getConnection() {
        return this.conn;
    }

    public void commit() {
        try {
            this.conn.commit();
        }
        catch (SQLException sqle) {
            throw new DaoException("\u30b3\u30df\u30c3\u30c8\u306f\u5931\u6557\u3057\u307e\u3057\u305f\u3002", sqle);
        }
    }

    public void rollback() {
        try {
            this.conn.rollback();
        }
        catch (SQLException sqle) {
            throw new DaoException("\u30ed\u30fc\u30eb\u30d0\u30c3\u30af\u306f\u5931\u6557\u3057\u307e\u3057\u305f\u3002", sqle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            this.conn.close();
        }
        catch (SQLException sqle) {
            this.logger.warn("\u30c8\u30e9\u30f3\u30b6\u30af\u30b7\u30e7\u30f3\u306e\u30af\u30ed\u30fc\u30ba\u306f\u5931\u6557\u3057\u307e\u3057\u305f\u3002", (Throwable)sqle);
        }
        finally {
            this.conn = null;
        }
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getOwner() {
        return this.owner;
    }
}

