require 'uconv'

class EzController < ApplicationController
  before_filter :set_charset
  after_filter :sjis_conv

  def set_charset
    @headers["Content-Type"] = "text/html; charset=Shift_JIS" 
  end
  
  def sjis_conv
    response.body = Uconv.u8tosjis(response.body)
  end
    
  def index
    tiddlers = Tiddler.find(:all, :order => "length(title) desc, title")
    
    if @params['title']
      @tiddler = Tiddler.find(:first, :conditions => "title = '#{@params['title']}'")
    else
      @tiddler = Tiddler.find(:first, :conditions => "title = 'StartHere'")
    end
    unless @tiddler
      @tiddler = Tiddler.new
      if @params['title']
        @tiddler.title = @params['title']
      else
        @tiddler.title = "StartHere"
      end
      @tiddler.content = "This tiddler doesn't yet exist."
    end
    @tiddler.render!(EzLinkManager.new, tiddlers)
    
    @menu = Tiddler.find(:first, :conditions => "title = 'MainMenu'")
    unless @menu
      @menu = Tiddler.new
      @menu.title = "MainMenu"
    end
    @menu.render!(EzLinkManager.new, tiddlers)
  end
end
