require 'cgi'
require 'wiki_words'

def escape_slash(str)
  str.gsub(/\//, "  ")
end

class LinkManager
  def make_link(name, text = nil, options = {})
    text = CGI.escapeHTML(text || WikiWords.separate(name))
    base_url = options[:base_url] || '..'
    make_tiddler_link(options[:tiddler], name, text, base_url)
  end
  
  def has_tiddler?(name)
    begin
      Tiddler.find(:first, :conditions => "title = '#{name}'")
    rescue
      nil
    end
  end
  
  def make_tiddler_link(tiddler, name, text, base_url)
    link = CGI.escape(escape_slash(name))
    if p = has_tiddler?(name)
      %{<a href="#{base_url}/#{link}" title="#{p.updated_at}">#{text}</a>}
    else
      text
    end
  end
end

class WikiLinkManager < LinkManager
  def make_tiddler_link(tiddler, name, text, base_url)
    link = CGI.escape(escape_slash(name))
    if p = has_tiddler?(name)
      unless p.color
        %{<a class="tiddlerExistNone" href="javascript:;" title="#{p.updated_at}" onclick="new Ajax.WikiUpdater($('tiddler_#{tiddler.title}'), '#{tiddler.title}', '#{name}', '#{base_url}/wiki/view/#{link}', {asynchronous:true}); return false;" onkeypress="new Ajax.WikiUpdater($('tiddler_#{tiddler.title}'), '#{tiddler.title}', '#{name}', '#{base_url}/wiki/view/#{link}', {asynchronous:true}); return false;">#{text}</a>}
      else
        %{<a class="tiddlerExist#{p.color.capitalize}" href="javascript:;" title="#{p.updated_at}" onclick="new Ajax.WikiUpdater($('tiddler_#{tiddler.title}'), '#{tiddler.title}', '#{name}', '#{base_url}/wiki/view/#{link}', {asynchronous:true}); return false;" onkeypress="new Ajax.WikiUpdater($('tiddler_#{tiddler.title}'), '#{tiddler.title}', '#{name}', '#{base_url}/wiki/view/#{link}', {asynchronous:true}); return false;">#{text}</a>}
      end
    else
      %{<a class="tiddlerNew" href="javascript:;" title="#{name} doesn't yet exist" onclick="new Ajax.WikiUpdater($('tiddler_#{tiddler.title}'), '#{tiddler.title}', '#{name}', '#{base_url}/wiki/view_nonexist/#{link}', {asynchronous:true}); return false;" onkeypress="new Ajax.WikiUpdater($('tiddler_#{tiddler.title}'), '#{tiddler.title}', '#{name}', '#{base_url}/wiki/view_nonexist/#{link}', {asynchronous:true}); return false;">#{text}</a>}
    end
  end
end

class MenuLinkManager < LinkManager
  def make_tiddler_link(tiddler, name, text, base_url)
    link = CGI.escape(escape_slash(name))
    if p = has_tiddler?(name)
      unless p.color
        %{<a class="tiddlerExistNone" href="javascript:;" title="#{p.updated_at}" onclick="new Ajax.WikiUpdater($('tiddlerDummy'), '#{tiddler.title}', '#{name}', '#{base_url}/wiki/view/#{link}', {asynchronous:true}); return false;" onkeypress="new Ajax.WikiUpdater($('tiddlerDummy'), '#{tiddler.title}', '#{name}', '#{base_url}/wiki/view/#{link}', {asynchronous:true}); return false;">#{text}</a>}
      else
        %{<a class="tiddlerExist#{p.color.capitalize}" href="javascript:;" title="#{p.updated_at}" onclick="new Ajax.WikiUpdater($('tiddlerDummy'), '#{tiddler.title}', '#{name}', '#{base_url}/wiki/view/#{link}', {asynchronous:true}); return false;" onkeypress="new Ajax.WikiUpdater($('tiddlerDummy'), '#{tiddler.title}', '#{name}', '#{base_url}/wiki/view/#{link}', {asynchronous:true}); return false;">#{text}</a>}
      end
    else
      %{<a class="tiddlerNew" href="javascript:;" title="#{name} doesn't yet exist" onclick="new Ajax.WikiUpdater($('tiddlerDummy'), '#{tiddler.title}', '#{name}', '#{base_url}/wiki/view_nonexist/#{link}', {asynchronous:true}); return false;" onkeypress="new Ajax.WikiUpdater($('tiddlerDummy'), '#{tiddler.title}', '#{name}', '#{base_url}/wiki/view_nonexist/#{link}', {asynchronous:true}); return false;">#{text}</a>}
    end
  end
end

class ReminderLinkManager < LinkManager
  def make_tiddler_link(tiddler, name, text, base_url)
    link = CGI.escape(escape_slash(name))
    if p = has_tiddler?(name)
      unless p.color
        %{<a class="tiddlerExistNone" href="javascript:;" title="#{p.title} (#{p.updated_at})" onclick="new Ajax.WikiUpdater($('tiddler_#{tiddler.title}'), '#{tiddler.title}', '#{name}', '#{base_url}/wiki/view/#{link}', {asynchronous:true}); return false;" onkeypress="new Ajax.WikiUpdater($('tiddler_#{tiddler.title}'), '#{tiddler.title}', '#{name}', '#{base_url}/wiki/view/#{link}', {asynchronous:true}); return false;">#{text}</a>}
      else
        %{<a class="tiddlerExist#{p.color.capitalize}" href="javascript:;" title="#{p.title} (#{p.updated_at})" onclick="new Ajax.WikiUpdater($('tiddler_#{tiddler.title}'), '#{tiddler.title}', '#{name}', '#{base_url}/wiki/view/#{link}', {asynchronous:true}); return false;" onkeypress="new Ajax.WikiUpdater($('tiddler_#{tiddler.title}'), '#{tiddler.title}', '#{name}', '#{base_url}/wiki/view/#{link}', {asynchronous:true}); return false;">#{text}</a>}
      end
    else
      text
    end
  end
end

class RSSLinkManager < LinkManager
  def make_tiddler_link(tiddler, name, text, base_url)
    link = CGI.escape(escape_slash(name))
    if p = has_tiddler?(name)
      %{<a href="#{base_url}/wiki/#{link}" title="#{p.updated_at}">#{text}</a>}
    else
      text
    end
  end
end

class EzLinkManager < LinkManager
  def make_tiddler_link(tiddler, name, text, base_url)
    base_url = ""
    link = CGI.escape(escape_slash(name))
    if p = has_tiddler?(name)
      %{<a href="#{base_url}/ez/#{link}">#{text}</a>}
    else
      text
    end
  end
end
