CREATE TABLE tiddlers (
  id SERIAL PRIMARY KEY NOT NULL,
  title varchar(255) NOT NULL default '',
  content text NOT NULL default '',
  autolink BOOL NOT NULL default TRUE,
  color varchar(15) default NULL,
  expire_cache BOOL NOT NULL default FALSE,
  created_at TIMESTAMP default NULL,
  updated_at TIMESTAMP default NULL,
  UNIQUE (title)
);

CREATE TABLE logs (
  id SERIAL PRIMARY KEY NOT NULL,
  tiddler_id int NOT NULL,
  title varchar(255) NOT NULL default '',
  operation varchar(15) NOT NULL default '',
  content text NOT NULL,
  created_at TIMESTAMP default NULL
);

CREATE TABLE aliases (
  id SERIAL PRIMARY KEY NOT NULL,
  tiddler_id int REFERENCES tiddlers,
  name varchar(255) NOT NULL default '',
  created_at TIMESTAMP default NULL
);

CREATE TABLE reminders (
  id SERIAL PRIMARY KEY NOT NULL,
  tiddler_id int REFERENCES tiddlers,
  date DATE NOT NULL,
  priority_type CHAR(1) NOT NULL default '',
  priority_number SMALLINT default NULL,
  content VARCHAR(255) NOT NULL default '',
  created_at TIMESTAMP default NULL,
  updated_at TIMESTAMP default NULL
);
