CREATE TABLE tiddlers (
  id INTEGER PRIMARY KEY NOT NULL,
  title VARCHAR(255) NOT NULL DEFAULT '',
  content TEXT NOT NULL DEFAULT '',
  autolink INTEGER NOT NULL DEFAULT 1,
  color VARCHAR(15) DEFAULT NULL,
  expire_cache INTEGER NOT NULL DEFAULT 0,
  created_at DATETIME DEFAULT NULL,
  updated_at DATETIME DEFAULT NULL,
  UNIQUE (title)
);

CREATE TABLE logs (
  id INTEGER PRIMARY KEY NOT NULL,
  tiddler_id INTEGER NOT NULL,
  title VARCHAR(255) NOT NULL DEFAULT '',
  operation VARCHAR(15) NOT NULL DEFAULT '',
  content TEXT NOT NULL,
  created_at DATETIME default NULL
);

CREATE TABLE aliases (
  id INTEGER PRIMARY KEY NOT NULL,
  tiddler_id INTEGER REFERENCES tiddlers,
  name VARCHAR(255) NOT NULL default '',
  created_at DATETIME default NULL
);

CREATE TABLE reminders (
  id INTEGER PRIMARY KEY NOT NULL,
  tiddler_id INTEGER REFERENCES tiddlers,
  date DATE NOT NULL,
  priority_type CHAR(1) NOT NULL DEFAULT '',
  priority_number INTEGER default NULL,
  content VARCHAR(255) NOT NULL DEFAULT '',
  created_at DATETIME DEFAULT NULL,
  updated_at DATETIME DEFAULT NULL
);
