#!/bin/sh

if [ "$1" = "" ]; then
    echo "Usage: $0 <version>"
    exit 1
fi

ver=$1
tag="VER_`echo ${ver} | sed 's|\.|_|g'`"

cvs ex -r ${tag} -d lesserwiki-${ver} lesserwiki
for i in `/bin/ls lib | grep -v 'CVS'`; do
    cp -r lib/$i lesserwiki-${ver}/lib
done

cd lesserwiki-${ver}
find . -name ".cvsignore" | xargs rm -f
mv config.in config
mkdir cache
chmod 777 cache
cd ..

zip -r lesserwiki-${ver}.zip lesserwiki-${ver}
