Ajax.WikiUpdater = Class.create();
Ajax.WikiUpdater.prototype = (new Ajax.Base()).extend({
  initialize: function(container, from, name, url, options) {
    this.tiddlerId = "tiddler_" + name;
    this.setOptions(options);
  
    if ($(this.tiddlerId)) {
      new Effect.ScrollTo(this.tiddlerId, { duration: 0.3 });
      new Effect.Highlight(this.tiddlerId)
      return false;
    }
    
    if (container) {
      this.container = container
      this.options.insertion = Insertion.After;
    }
    else {
      this.container = $('tiddlerDummy');
      this.options.insertion = Insertion.After;
    }
    
    this.options.onComplete = this.loadComplete.bind(this);
    //this.options.onLoading = this.loadStart.bind(this);
    
    this.request = new Ajax.Request(url, this.options);
  },
  
  loadComplete: function() {
    if (this.options.insertion) {
      new this.options.insertion(this.container,
        this.request.transport.responseText);
    } else {
      this.container.innerHTML = this.request.transport.responseText;
    }

    new Effect.Appear(this.tiddlerId, { duration: 0.5 });
    new Effect.ScrollTo(this.tiddlerId, { duration: 0.3 });
    new Effect.Highlight(this.tiddlerId);
  },
  
  loadStart: function() {
  }
});

function showMessage(msg) {
  //$('message').innerHTML = msg;
  //Element.show('message');
}

function clearMessage() {
  //Element.hide('message');
}

function showToolbar(title) {
  $('toolbar_' + title).style.visibility = "visible";
}

function hideToolbar(title) {
  $('toolbar_' + title).style.visibility = "hidden";
}

function showViewer(title) {
  Element.show('viewer_' + title);
}

function hideViewer(title) {
  Element.hide('viewer_' + title);
}

function showEditor(title) {
  Element.show('editor_' + title);
}

function hideEditor(title) {
  Element.hide('editor_' + title);
}

function showNormalToolbar(title) {
  Element.show('toolbar_close_' + title);
  Element.show('toolbar_edit_' + title);
  Element.show('toolbar_permalink_' + title);
}

function showEditToolbar(title) {
  Element.show('toolbar_done_' + title);
  Element.show('toolbar_cancel_' + title);
  Element.show('toolbar_delete_' + title);
}

function hideNormalToolbar(title) {
  Element.hide('toolbar_close_' + title);
  Element.hide('toolbar_edit_' + title);
  Element.hide('toolbar_permalink_' + title);
}

function hideEditToolbar(title) {
  Element.hide('toolbar_done_' + title);
  Element.hide('toolbar_cancel_' + title);
  Element.hide('toolbar_delete_' + title);
}

function itemLoading(title) {
  hideNormalToolbar(title);
  hideEditToolbar(title);
  
  if ($('loading_' + title)) {
    Element.show('loading_' + title);
    $('loading_' + title).style.margin = "0 0 0 5px";
  }
}

function itemAdded(title) {
  if ($('loading_' + title))
    Element.hide('loading_' + title);
}

function searchLoading() {
  
}

function searchComplete() {
  
}

function editTiddler(title) {
  clearMessage();
  
  hideNormalToolbar(title);
  showEditToolbar(title);
  
  hideViewer(title);
  showEditor(title);

  $('content_' + title).focus();
}

function closeTiddler(title) {
  var tiddlerId = 'tiddler_' + title;
  new Effect.Fade(tiddlerId, {
    duration: 0.5,
    afterFinish: function(effect) {
      $(tiddlerId).parentNode.removeChild($(tiddlerId));
    }});
}

function deleteTiddler(title, url) {
  if (confirm('Do you really want to delete "' + title + '" ?')) {
    new Ajax.Request(url, {
      asynchronous: true
    });
    closeTiddler(title);
  }
}

function saveTiddler(title) {
  $('submit_' + title).click()
}

function cancelTiddler(title, state) {
  clearMessage();

  if (state == 'new') {
    closeTiddler(title);
  } else {
    hideEditToolbar(title);
    showNormalToolbar(title);
    
    hideEditor(title);
    showViewer(title);
  }
}

function editLoading(title) {
  itemLoading(title);
}

function editComplete(title) {
  itemAdded(title);
}

function changeId(title) {
  tiddler = $('tiddler_' + title);
  for (var i = 0; i < tiddler.childNodes.length; i++) {
    if (tiddler.childNodes[i].id &&
        tiddler.childNodes[i].id.substr(0, 7) == "viewer_") {
      var newTitle = tiddler.childNodes[i].id.substr(7);
      tiddler.id = 'tiddler_' + newTitle;
    }
  }
}

function closeAllTiddlers() {
  var place = document.getElementById("displayArea");
  var tiddler = place.firstChild;
  var nextTiddler;
  while (tiddler) {
    nextTiddler = tiddler.nextSibling;
    if (tiddler.id) {
      if (tiddler.id.substr(0, 8) == "tiddler_") {
        var title = tiddler.id.substr(8);
        if ($('editor_' + title).style.display == "none")
          place.removeChild(tiddler);
      }
    }
    tiddler = nextTiddler;
  }
}

function openOptions() {
  alert("Not implemented yet");
}

function dateString(d) {
  return d.getFullYear() + '-' + (d.getMonth() + 1 < 10 ? '0' : '')
         + (d.getMonth() + 1) + '-' + (d.getDate() < 10 ? '0' : '')
         + d.getDate();
}


var selText = "";

function storeSelectedText()
{
  var text = "";
  if (window.getSelection) {
    // Safari, Mozilla
    text = window.getSelection() + "";
  } else if (document.getSelection) {
    // Mozilla
    text = document.getSelection();
  } else if (document.selection) {
    // IE, Opera
    text = document.selection.createRange().text;
  }
  selText = text;
  return text;
}

function escapeSlash(str) {
  return str.replace(/\//g, "  ");
}

function unescapeSlash(str) {
  return str.replace(/  /g, "/");
}

function newTiddler(baseurl) {
  var text = null;
  if (selText && selText.length > 0) {
    text = escapeSlash(selText.replace(/\s+/g, " ").replace(/^\s*(.*)\s*/, "$1"));
  } else {
    text = dateString(new Date());
  }
  new Ajax.WikiUpdater($('tiddlerDummy'), null, text,
                       baseurl + encodeURIComponent(text), {asynchronous:true});
}

var keyEvent=null;
function onKeyDownEvent(e) {
  keyEvent = e;
}
window.onkeydown = onKeyDownEvent;

function onEditKey(title)
{
  var e = window.event;
  var consume = false;

  if (!e) e = keyEvent;

  switch (e.keyCode) {
  case 13: // Ctrl-Enter
  case 10: // Ctrl-Enter on IE PC
  case 77: // Ctrl-Enter is "M" on some platforms
    if (e.ctrlKey) {
      saveTiddler(title);
      consume = true;
    }
    break;
  case 27: // Escape
    cancelTiddler(title, 'view');
    consume = true;
    break;
  }

  e.cancelBubble = consume;
  if (consume)
    if (e.stopPropagation) e.stopPropagation();
  
  return !consume;
}

function onLabelChange(title)
{
  var select = $('labelSelect' + title);
  var color = select.options[select.selectedIndex].text;
  color = color.substr(0, 1).toUpperCase(0) + color.substr(1);
  $('colorBox' + title).className = "colorBox" + color;
}

function onClickTimeline()
{
  Element.hide('tabContentColors');
  Element.show('tabContentTimeline');
}

function onClickColors()
{
  Element.hide('tabContentTimeline');
  Element.show('tabContentColors');
}

function onClickColor(color)
{
  Element.hide('colorContentNone');
  Element.hide('colorContentRed');
  Element.hide('colorContentOrange');
  Element.hide('colorContentYellow');
  Element.hide('colorContentGreen');
  Element.hide('colorContentBlue');
  Element.hide('colorContentPurple');
  Element.hide('colorContentGray');
  Element.show('colorContent' + color);
}

function main()
{
  /*
  if ($('search') &&
      navigator.userAgent.toLowerCase().indexOf("safari") >= 0) {
    $('search').setAttribute("type", "search");
    $('search').setAttribute("results", "5");
  }
  */
}