require 'rss/maker'
require 'rss/content'
require 'site'
require 'log'

class RssController < ApplicationController
  #caches_page :index
  
  def index
    v1
  end
  
  def v1
    # URL parameters

    # @params['render']
    # when 'on'
    #  -- content will be rendered (*render before comparing)
    # else # (all the other of above)
    #  -- content will not be rendered

    # @params['style']
    # when 'on'
    #  -- link to CSS will be included to output
    # else # (all the other of above)
    #  -- link to CSS will NOT be included to output
    
    # @params['diff']
    # related to what to be put into content:encoded element.
    # when "line"
    #  -- put diff between last and second last content (resolution: line)
    # when "word"
    #  -- put diff between last and second last content (resolution: word)
    # else # (all the other of above)
    #  --  put last content to content:encoded element

    # @params['digest'] 
    # (it effects only when params['diff'] equals 'line' or 'word')
    # when 'on'
    #  -- use digest mode with docdiff library
    # else # (all the other of above)
    #  -- NOT use digest mode with docdiff library
    
    render = (@params['render'] == 'on') ? true : false    
    style = (@params['style'] == 'on') ? true : false
    if @params['diff'] == 'line'
      diff = 'line'
    elsif @params['diff'] == 'word'
      diff = 'word'
    else
      diff = nil
    end
    digest = (@params['digest'] == 'on') ? true : false
    
    # --
    @tiddlers = Tiddler.find(:all, :order => "updated_at desc", :limit => "#{RSS_ITEM_MAX}")
    tiddlers_for_render = Tiddler.find(:all, :order => "length(title) desc, title")
    link_manager = RSSLinkManager.instance

    rss = RSS::Maker.make("1.0") do |maker|
      css = maker.xml_stylesheets.new_xml_stylesheet
      base_url = SITE_BASE_URL.sub(/\/+\Z/, "")
      css.href = "#{base_url}/stylesheets/wiki.css"
      css.type = "text/css"
      maker.channel.about = "#{base_url}/rss"
      maker.channel.title = SITE_TITLE
      maker.channel.description = SITE_DESCRIPTION
      maker.channel.link = base_url
      
      maker.items.do_sort = true
      
      @tiddlers.each do |tiddler|
        item = maker.items.new_item
        item.link = url_for :controller => "wiki", :action => "index", :title => tiddler.title
        item.title = tiddler.title
        item.date = tiddler.updated_at
        
        #** diff / render / digest parameters are related to this block
        if diff != nil and (diff == 'line' or diff == 'word')
          # set new_content
          new_content = get_content(tiddler, render, link_manager, tiddlers_for_render)
          # set old_content
          if tiddler.logs.length < 2
            old_content = ""
          else
            tiddler.content = tiddler.logs[1].content
            old_content = get_content(tiddler, render, link_manager, tiddlers_for_render)
          end
          item.content_encoded = Tiddler.diff_between_2contents(old_content, new_content, diff, digest)
          
        else # diff = 'line' and diff != 'word'
          item.content_encoded = get_content(tiddler, render, link_manager, tiddlers_for_render)
        end
        
        #** style parameter is related to this block
        if style
          item.content_encoded = %{<link href="#{base_url}/stylesheets/wiki.css" media="screen" rel="Stylesheet" type="text/css" /><pre>#{item.content_encoded}</pre>}
        else
          if render
            item.content_encoded = item.content_encoded
          else
            item.content_encoded = "<pre>#{item.content_encoded}</pre>"
          end
        end
        
      end
    end
    
    @headers["Content-Type"] = 'application/xml; charset=UTF-8'
    render(:text => rss, :layout => false)
  end
  
  private
  
  def get_content(tiddler, render, link_manager, tiddlers_for_render)
    if render == true
      tiddler.render!(link_manager, tiddlers_for_render)
      tiddler.rendered_content
    else
      tiddler.content
    end
  end
end
