module LesserWiki
  class Log < ActiveRecord::Base
    belongs_to :tiddler
  
    def self.create(tiddler)
      self.log(tiddler, 'create')
    end
  
    def self.delete(tiddler)
      self.log(tiddler, 'delete')
    end
  
    def self.edit(tiddler)
      self.log(tiddler, 'edit')
    end
  
    def self.rename(tiddler)
      self.log(tiddler, 'rename')
    end
  
    def self.log(tiddler, operation)
      log = self.new
      log.tiddler = tiddler
      log.title = tiddler.title
      log.operation = operation
      log.content = tiddler.content
      log.save
    end
  end
end