CREATE TABLE tiddlers (
  id bigint(20) unsigned NOT NULL auto_increment,
  title varchar(255) binary NOT NULL default '',
  content text NOT NULL default '',
  autolink BOOL NOT NULL default 1,
  color varchar(15) default NULL,
  expire_cache BOOL NOT NULL default 0,
  created_at datetime default NULL,
  updated_at datetime default NULL,
  PRIMARY KEY  (id),
  UNIQUE KEY title (title)
) TYPE=MyISAM;

CREATE TABLE aliases (
  id bigint(20) unsigned NOT NULL auto_increment,
  tiddler_id bigint(20) unsigned NOT NULL default '0',
  name varchar(255) binary NOT NULL default '',
  created_at datetime default NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM;

CREATE TABLE tags (
  id bigint(20) unsigned NOT NULL auto_increment,
  name varchar(255) binary NOT NULL default '',
  PRIMARY KEY  (id),
  UNIQUE KEY name (name)
) TYPE=MyISAM;

CREATE TABLE tags_tiddlers (
  tiddler_id bigint(20) unsigned NOT NULL default '0',
  tag_id bigint(20) unsigned NOT NULL default '0',
  created_at datetime default NULL
) TYPE=MyISAM;

CREATE TABLE reminders (
  id bigint(20) unsigned NOT NULL auto_increment,
  tiddler_id bigint(20) unsigned NOT NULL default '0',
  date DATE NOT NULL,
  priority_type CHAR(1) NOT NULL default '',
  priority_number TINYINT default NULL,
  content VARCHAR(255) NOT NULL default '',
  created_at datetime default NULL,
  updated_at datetime default NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM;

CREATE TABLE logs (
  id bigint(20) unsigned NOT NULL auto_increment,
  tiddler_id bigint(20) unsigned NOT NULL default '0',
  title varchar(255) NOT NULL default '',
  operation varchar(15) NOT NULL default '',
  content text NOT NULL,
  created_at datetime default NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM;
