# The filters added to this controller will be run for all controllers in the application.
# Likewise will all the methods added be available for all controllers.

require 'uconv'

class ApplicationController < ActionController::Base
  def unescape_slash(str)
    if str
      str.gsub(/  /, "/")
    else
      nil
    end
  end
  
  def set_charset_sjis
    @headers["Content-Type"] = "text/html; charset=Shift_JIS"
  end

  def sjis_conv
    response.body = Uconv.u8tosjis(response.body)
  end
  
  def i18n_message(key, args = nil)
    I18n::MessageResources.instance.message(key, SITE_LOCALE, args)
  end
  
  def split_strings(str)
    array = []
    if str and str.length > 0
      str = str.gsub(/^\s*(.*)\s*$/, '\\1').gsub(/\s+/, " ")
      str.gsub!(/\[\[\s*(.*)\s*\]\]/) {|s| $1.sub(/ $/, "").gsub(/ /, "\t") }
      array = str.split(/ /)
      array.each {|a| a.gsub!(/\t/, " ") }.uniq!    
    end
    array
  end
  
  def save_and_expire(tiddler, title, content, aliases, tags, autolink, color, tiddlers)
    # expire the cache of this tiddler
    expire_action :controller => "wiki", :action => "view", :title => tiddler.escaped_title
    expire_action :controller => "wiki", :action => "view", :title => title
    
    tiddlers.select {|t|
      /#{Regexp.escape(t.title)}/ =~ tiddler.content or
      (content and /#{Regexp.escape(t.title)}/ =~ content) or
       /#{Regexp.escape(tiddler.title)}/ =~ t.content
    }.each do |t|
      expire_action :controller => "wiki", :action => "view", :title => t.escaped_title
    end

    Tiddler.transaction do
      tiddler.title = title
      tiddler.content = content
      tiddler.autolink = autolink
      tiddler.color = color
      tiddler.expire_cache = 0 if tiddler.expire_cache == nil
      tiddler.save
      
      # delete old aliases
      tiddler.aliases.select {|a| !aliases.include?(a.name) }.each do |a|
        delete_alias(tiddler, a)
      end

      # create new aliases
      aliases.select {|a|
        !Alias.find(:first, :conditions => "tiddler_id = #{tiddler.id} and name = '#{a}'")
      }.each do |a|
        create_alias(tiddler, a)
      end

      # delete tags
      tiddler.tags.select {|t| !tags.include?(t.name) }.each do |t|
        tiddler.tags.delete(t)
        if t.tiddlers.empty?
          t.destroy
        else
          Tiddler.find(:all, :joins => "as t1 inner join tags_tiddlers as t2 inner join tags as t3 on t1.id = t2.tiddler_id and t2.tag_id = t3.id").each do |t|
            expire_action :controller => "wiki", :action => "view", :title => t.escaped_title
          end
        end
      end

      # add tags
      tags.each do |t|
        tag = Tag.find(:first, :conditions => ["name = ?", t])
        unless tag
          # create a new tag and link to this tiddler
          tag = Tag.new
          tag.name = t
          tiddler.tags << tag
        else
          # add this tiddler to the existing tag
          unless tiddler.tags.include?(tag)
            tiddler.tags << tag
            Tiddler.find(:all, :joins => "as t1 inner join tags_tiddlers as t2 inner join tags as t3 on t1.id = t2.tiddler_id and t2.tag_id = t3.id").each do |t|
              expire_action :controller => "wiki", :action => "view", :title => t.escaped_title
            end
          end
        end
      end
    end
  end

  def create_alias(tiddler, name)
    alias_ = Alias.new
    alias_.tiddler = tiddler
    alias_.name = name
    tiddler.aliases << alias_

    Tiddler.find(:all, :conditions => "content like '%#{alias_.name}%'").each do |t|
      expire_action :controller => "wiki", :action => "view", :title => t.escaped_title
    end
  end

  def delete_alias(tiddler, alias_)
    # expire the cache of this tiddler
    expire_action :controller => "wiki", :action => "view", :title => tiddler.escaped_title
    
    Tiddler.find(:all, :conditions => "content like '%#{alias_.name}%'").each do |t|
      expire_action :controller => "wiki", :action => "view", :title => t.escaped_title
    end

    tiddler.aliases.delete(alias_)
    alias_.destroy
  end

  def delete_and_expire(tiddler, tiddlers)
    # expire the cache of this tiddler
    expire_action :controller => "wiki", :action => "view", :title => tiddler.escaped_title
    
    tiddler.aliases.each do |a|
      Tiddler.find(:all, :conditions => "content like '%#{a.name}%'").each do |t|
        expire_action :controller => "wiki", :action => "view", :title => t.escaped_title
      end
    end

    # delete tags
    tiddler.tags.each do |t|
      tiddler.tags.delete(t)
      if t.tiddlers.empty?
        t.destroy
      else
        Tiddler.find(:all, :joins => "as t1 inner join tags_tiddlers as t2 inner join tags as t3 on t1.id = t2.tiddler_id and t2.tag_id = t3.id").each do |t|
          expire_action :controller => "wiki", :action => "view", :title => t.escaped_title
        end
      end
    end

    tiddlers.select {|t|
      /#{Regexp.escape(t.title)}/ =~ tiddler.content or
      /#{Regexp.escape(tiddler.title)}/ =~ t.content
    }.each do |t|
      expire_action :controller => "wiki", :action => "view", :title => t.escaped_title
    end

    tiddler.destroy
  end
end
