require 'cgi'
require 'thread'
require 'wiki_words'
require 'site'

def escape_slash(str)
  str.gsub(/\//, "  ")
end

def message(key, args = nil)
  I18n::MessageResources.instance.message(key, SITE_LOCALE, args)
end

def format_time(time)
  time.strftime("%Y-%m-%d %H:%M:%S (%Z)")
end

class LinkManager
  private_class_method :new
  @instance = nil
  
  def self.instance
    unless @instance
      Mutex.new.synchronize do
        @instance = new
      end
    end
    @instance
  end
  
  def make_link(name, text = nil, options = {})
    text = CGI.escapeHTML(text || WikiWords.separate(name))
    base_url = options[:base_url] || '..'
    make_tiddler_link(options[:tiddler], name, text, base_url)
  end
  
  def has_tiddler?(name)
    begin
      Tiddler.find(:first, :conditions => "title = '#{name}'")
    rescue
      nil
    end
  end
  
  def make_tiddler_link(tiddler, name, text, base_url)
    link = CGI.escape(escape_slash(name))
    if p = has_tiddler?(name)
      %{<a href="#{base_url}/#{link}" title="#{format_time(p.updated_at)}">#{text}</a>}
    else
      text
    end
  end
end

class WikiLinkManager < LinkManager
  def make_tiddler_link(tiddler, name, text, base_url)
    link = CGI.escape(escape_slash(name))
    if p = has_tiddler?(name)
      %{<a class="tiddlerExist#{p.color_name.capitalize}" href="javascript:;" title="#{format_time(p.updated_at)}" onclick="new Ajax.WikiUpdater($('tiddler_#{tiddler.title}'), '#{p.color_name.capitalize}', '#{name}', '#{base_url}/wiki/view/#{link}', {asynchronous:true}); return false;" onkeypress="new Ajax.WikiUpdater($('tiddler_#{tiddler.title}'), '#{p.color_name.capitalize}', '#{name}', '#{base_url}/wiki/view/#{link}', {asynchronous:true}); return false;">#{text}</a>}
    else
      %{<a class="tiddlerNew" href="javascript:;" title="#{name} doesn't yet exist" onclick="new Ajax.WikiUpdater($('tiddler_#{tiddler.title}'), 'None', '#{name}', '#{base_url}/wiki/view/#{link}', {asynchronous:true}); return false;" onkeypress="new Ajax.WikiUpdater($('tiddler_#{tiddler.title}'), 'None', '#{name}', '#{base_url}/wiki/view/#{link}', {asynchronous:true}); return false;">#{text}</a>}
    end
  end
end

class MenuLinkManager < LinkManager
  def make_tiddler_link(tiddler, name, text, base_url)
    link = CGI.escape(escape_slash(name))
    if p = has_tiddler?(name)
      %{<a class="tiddlerExist#{p.color_name.capitalize}" href="javascript:;" title="#{format_time(p.updated_at)}" onclick="new Ajax.WikiUpdater($('tiddlerDummy'), '#{p.color_name.capitalize}', '#{name}', '#{base_url}/wiki/view/#{link}', {asynchronous:true}); return false;" onkeypress="new Ajax.WikiUpdater($('tiddlerDummy'), '#{p.color_name.capitalize}', '#{name}', '#{base_url}/wiki/view/#{link}', {asynchronous:true}); return false;">#{text}</a>}
    else
      %{<a class="tiddlerNew" href="javascript:;" title="#{name} doesn't yet exist" onclick="new Ajax.WikiUpdater($('tiddlerDummy'), 'None', '#{name}', '#{base_url}/wiki/view/#{link}', {asynchronous:true}); return false;" onkeypress="new Ajax.WikiUpdater($('tiddlerDummy'), 'None', '#{name}', '#{base_url}/wiki/view/#{link}', {asynchronous:true}); return false;">#{text}</a>}
    end
  end
end

class ReminderLinkManager < LinkManager
  def make_tiddler_link(tiddler, name, text, base_url)
    link = CGI.escape(escape_slash(name))
    if p = has_tiddler?(name)
      %{<a class="tiddlerExist#{p.color_name.capitalize}" href="javascript:;" title="[#{p.title}] #{format_time(p.updated_at)}" onclick="new Ajax.WikiUpdater($('tiddler_#{tiddler.title}'), '#{p.color_name.capitalize}', '#{name}', '#{base_url}/wiki/view/#{link}', {asynchronous:true}); return false;" onkeypress="new Ajax.WikiUpdater($('tiddler_#{tiddler.title}'), '#{p.color_name.capitalize}', '#{name}', '#{base_url}/wiki/view/#{link}', {asynchronous:true}); return false;">#{text}</a>}
    else
      text
    end
  end
end

class RSSLinkManager < LinkManager
  def make_tiddler_link(tiddler, name, text, base_url)
    link = CGI.escape(escape_slash(name))
    if p = has_tiddler?(name)
      %{<a href="#{base_url}/tiddler/#{link}" title="#{format_time(p.updated_at)}">#{text}</a>}
    else
      text
    end
  end
end

class EzLinkManager < LinkManager
  def make_tiddler_link(tiddler, name, text, base_url)
    base_url = ""
    link = CGI.escape(escape_slash(name))
    if p = has_tiddler?(name)
      %{<a href="#{base_url}/ez/#{link}">#{text}</a>}
    else
      %{<a href="#{base_url}/ez/new/#{link}"><img localsrc="6"/>#{text}<img localsrc="5"/></a>}
    end
  end
end

class EzViewLinkManager < LinkManager
  def make_tiddler_link(tiddler, name, text, base_url)
    base_url = ""
    link = CGI.escape(escape_slash(name))
    if p = has_tiddler?(name)
      %{<a href="#{base_url}/ezv/#{link}">#{text}</a>}
    else
      text
    end
  end
end
