class Tag < ActiveRecord::Base
  has_and_belongs_to_many :tiddlers
  attr_accessor :level, :count
  
  include ModelHelper
    
  def escaped_name
    escape_slash(self.name)
  end
end

class TagCloud
  def initialize
    @counts = Hash.new
  end

  def add(tag, count)
    @counts[tag] = tag.count = count
  end
  
  def calculate(limit = nil)
    tags = @counts.sort_by {|a, b| b }.reverse.map {|a, b| a }
    tags = tags[0..limit-1] if limit
    if tags.empty?
      return ""
    elsif tags.size == 1
      tag = tags[0]
      tag.level = 24
      return [tag]
    end

    min = Math.sqrt(@counts[tags.last])
    max = Math.sqrt(@counts[tags.first])
    factor = 0

    # special case all tags having the same count
    if max - min == 0
      min = min - 24
      factor = 1
    else
      factor = 24 / (max - min)
    end

    tags.each do |tag|
      tag.level = ((Math.sqrt(tag.count) - min) * factor).to_i
    end
    
    tags.sort_by {|t| t.name }
  end
end