CREATE TABLE tiddlers (
  id SERIAL PRIMARY KEY NOT NULL,
  title varchar(255) NOT NULL default '',
  content text NOT NULL default '',
  autolink smallint NOT NULL default 1,
  color varchar(15) default NULL,
  expire_cache smallint NOT NULL default 0,
  created_at TIMESTAMP default NULL,
  updated_at TIMESTAMP default NULL,
  UNIQUE (title)
);

CREATE TABLE aliases (
  id SERIAL PRIMARY KEY NOT NULL,
  tiddler_id int REFERENCES tiddlers,
  name varchar(255) NOT NULL default '',
  created_at TIMESTAMP default NULL
);

CREATE TABLE tags (
  id SERIAL PRIMARY KEY NOT NULL,
  name varchar(255) NOT NULL default '',
  created_at TIMESTAMP default NULL,
  updated_at TIMESTAMP default NULL,
  UNIQUE (name)
);

CREATE TABLE tags_tiddlers (
  tiddler_id int REFERENCES tiddlers,
  tag_id int REFERENCES tags,
  created_at TIMESTAMP default NULL
);

CREATE TABLE reminders (
  id SERIAL PRIMARY KEY NOT NULL,
  tiddler_id int REFERENCES tiddlers,
  date DATE NOT NULL,
  priority_type CHAR(1) NOT NULL default '',
  priority_number SMALLINT default NULL,
  content VARCHAR(255) NOT NULL default '',
  created_at TIMESTAMP default NULL,
  updated_at TIMESTAMP default NULL
);

CREATE TABLE logs (
  id SERIAL PRIMARY KEY NOT NULL,
  tiddler_id int NOT NULL,
  title varchar(255) NOT NULL default '',
  operation varchar(15) NOT NULL default '',
  content text NOT NULL,
  created_at TIMESTAMP default NULL
);
