class AccountController < ApplicationController
  layout "admin"
  
  def login
    case @request.method
      when :post
      if user = User.authenticate(@params[:user_login], @params[:user_password])
        @session[:user] = user
        if user.administrator == 1 or user.administrator == true
          flash['notice'] = "Login successful"
          cookies[:is_admin] = "yes"
          redirect_back_or_default :controller => "admin/general", :action => "index"
        else
          redirect_back_or_default :controller => "wiki", :action => "index"
        end
      else
        flash.now['notice'] = "Login unsuccessful"
        @login = @params[:user_login]
      end
    end
  end
  
  def admin_signup
    redirect_to :action => "login" and return unless User.count.zero?
    
    @user = User.new(@params[:user])
    @user.administrator = 1
    
    if @request.post? and @user.save
      @session[:user] = User.authenticate(@user.login, @params[:user][:password])
      flash['notice'] = "Administrator signup successful"
      redirect_to :controller => "admin", :action => "index"
      return
    end
  end
  
  #def signup
  #  redirect_to :action => "login" and return unless User.count.zero?
  #  
  #  @user = User.new(@params[:user])
  #  
  #  if @request.post? and @user.save
  #    @session[:user] = User.authenticate(@user.login, @params[:user][:password])
  #    flash['notice'] = "Signup successful"
  #    redirect_to :controller => "local_admin", :action => "index", :user => @session[:user]
  #    return
  #  end
  #end
  
  def logout
    @session[:user] = nil
    cookies.delete :is_admin
  end
end
