class Admin::GeneralController < ApplicationController
  cattr_accessor :look_for_migrations
  @@look_for_migrations = true
  
  layout "admin"
  before_filter :login_required, :except => [ :login, :admin_signup ]
  before_filter :look_for_needed_db_updates,
                :except => [ :login, :admin_signup, :update_database, :migrate ]
  
  def index
    @is_ok = config.is_ok?
  end
  
  def users
    @is_ok = config.is_ok?
  end
  
  def update_config
    if request.post? 
      Setting.transaction do 
        for field, value in params[:setting]
          setting = find_or_create(field)
          setting.value = value
          setting.save
        end
      end
      FileUtils.rm_rf(Dir.glob("#{RAILS_ROOT}/cache/*"))
      flash[:notice] = 'Updated. Please restart the server.'
      redirect_to :action => 'index'
    end
  end
  
  def migrate
    if request.post?      
      Migrator.migrate
      redirect_to :action => 'update_database'
    end
  end
  
  def update_database
    @current_version = Migrator.current_schema_version
    @needed_version = Migrator.max_schema_version    
    @support = Migrator.db_supports_migrations?
    @needed_migrations = 
      Migrator.available_migrations[@current_version..@needed_version].collect do |mig|   
        mig.scan(/\d+\_([\w_]+)\.rb$/).flatten.first.humanize
      end
  end
  
  private
  
  def authorize?(user)
    @session[:user].administrator == 1 or @session[:user].administrator == true
  end
  
  def look_for_needed_db_updates
    if Migrator.offer_migration_when_available
      redirect_to :action => 'update_database' if Migrator.current_schema_version != Migrator.max_schema_version
    end
  end
  
  def find_or_create(name)
    unless setting = Setting.find_by_name(name)
      setting = Setting.new("name" => name)
    end
    setting
  end
end
