require_dependency 'log'

class EzController < ApplicationController
  before_filter :set_charset_sjis
  after_filter :sjis_conv
  #caches_action :index  # If you use caches, after_filter is not applied
  
  def index
    tiddlers = Tiddler.find(:all, :order => "length(title) desc, title")
    
    if @params['title']
      @tiddler =
        Tiddler.find(:first,
                     :conditions => [ "title = ?",
                                      unescape_slash(@params['title']) ])
    else
      @tiddler =
        Tiddler.find(:first,
                     :conditions => [ "title = ?", "StartHere" ])
    end
    unless @tiddler
      @tiddler = Tiddler.new
      if @params['title']
        @tiddler.title = unescape_slash(@params['title'])
      else
        @tiddler.title = "StartHere"
      end
      @tiddler.content = nil
    end
    @tiddler.render!(EzLinkManager.instance, tiddlers)
    
    @menu = Tiddler.find(:first, :conditions => ["title = ?", "EzMenu"])
    unless @menu
      @menu = Tiddler.new
      @menu.title = "EzMenu"
    end
    @menu.render!(EzLinkManager.instance, tiddlers)
  end
  
  def edit
    @tiddler = nil
    if @params['title'] and @params['title'].length > 0
      @tiddler =
        Tiddler.find(:first,
                     :conditions => [ "title = ?",
                                      unescape_slash(@params['title']) ])
    end
    unless @tiddler
      @tiddler = Tiddler.new
      if @params['title'] and @params['title'].length > 0
        @tiddler.title = unescape_slash(@params['title'])
      else
        @tiddler.title = ""
      end
      @tiddler.content = ""
      @tiddler.autolink = 1
    end
  end
  
  def confirm
    tiddlers =
      Tiddler.find(:all, :order => "length(title) desc, title")
    @tiddler =
      Tiddler.find(:first,
                   :conditions => [ "title = ?",
                                    unescape_slash(@params['title']) ])
    @menu =
      Tiddler.find(:first, :conditions => [ "title = ?", "EzMenu" ])
    unless @menu
      @menu = Tiddler.new
      @menu.title = "EzMenu"
    end
    @menu.render!(EzLinkManager.instance, tiddlers)
  end
  
  def delete
    tiddlers =
      Tiddler.find(:all, :order => "length(title) desc, title")
    @tiddler =
      Tiddler.find(:first,
                   :conditions => [ "title = ?", 
                                    unescape_slash(@params['title']) ])
    if @tiddler
      LesserWiki::Log.delete(@tiddler)
      delete_and_expire(@tiddler, tiddlers)
    end
    @menu = Tiddler.find(:first, :conditions => ["title = ?", "EzMenu"])
    unless @menu
      @menu = Tiddler.new
      @menu.title = "EzMenu"
    end
    @menu.render!(EzLinkManager.instance, tiddlers)
  end
  
  def new
    @tiddler = Tiddler.new
    @tiddler.title = ""
    @tiddler.content = ""
    @tiddler.autolink = 1
    @tiddler.render!(EzLinkManager.instance)
  end
  
  def save
    title = Uconv.sjistou8(unescape_slash(@params['title']))
    content = Uconv.sjistou8(@params['content'])
    last_title = Uconv.sjistou8(@params['last_title'])
    autolink = @params['autolink'].to_i
    color = Tiddler::COLORS.include?(@params['color']) ? @params['color'] : nil
    aliases = split_strings(@params['aliases'])
    tags = split_strings(@params['tags'])
    flash[:note] = nil

    tiddlers = Tiddler.find(:all, :order => "length(title) desc, title")

    if title == last_title
      @tiddler =
        Tiddler.find(:first,
                     :conditions => [ "title = ?", 
                                      unescape_slash(title) ])
      if @tiddler
        if @tiddler.content_digest == @params['last_content_digest']
          if !@tiddler.same_content(content) or
             @tiddler.autolink != autolink or
             @tiddler.color != color or
             @tiddler.aliases.map {|a| a.name } != aliases or
             @tiddler.tags.map {|t| t.name } != tags then
            save_and_expire(@tiddler, unescape_slash(title), content,
                            aliases, tags, autolink, color, tiddlers)
            LesserWiki::Log.edit(@tiddler)
            redirect_to :action => "index", :title => title
          end
        else
          flash[:note] = i18n_message("flash_conflict")
          @tiddler.last_content = @tiddler.content
          @tiddler.content = content
          @tiddler.autolink = autolink
          @tiddler.color = color
          render_action :edit
        end
      else  # @tiddler == nil
        @tiddler = Tiddler.new
        @tiddler.title = ""
        @tiddler.content = ""
        save_and_expire(@tiddler, unescape_slash(title), content,
                        aliases, tags, autolink, color, tiddlers)
        LesserWiki::Log.create(@tiddler)
        redirect_to :action => "index", :title => title
      end
    else  # title != last_title
      @tiddler =
        Tiddler.find(:first,
                     :conditions => [ "title = ?",
                                      unescape_slash(title) ])
      last_tiddler =
        Tiddler.find(:first,
                     :conditions => [ "title = ?",
                                      unescape_slash(last_title) ])
      if @tiddler
        flash[:note] = i18n_message("flash_exist", [@tiddler.title])
        #@tiddler.title = last_title
        @tiddler.last_content = @tiddler.content
        @tiddler.content = content
        @tiddler.autolink = autolink
        @tiddler.color = color
        render_action :edit
      else
        if last_tiddler and
           last_tiddler.content_digest != @params['last_content_digest'] then
          flash[:note] = i18n_message("flash_conflict")
          @tiddler = last_tiddler
          @tiddler.last_content = @tiddler.content
          @tiddler.content = content
          @tiddler.autolink = autolink
          render_action :edit
        else
          @tiddler = Tiddler.new
          @tiddler.title = ""
          @tiddler.content = ""
          save_and_expire(@tiddler, unescape_slash(title), content,
                          aliases, tags, autolink, color, tiddlers)
          if last_tiddler
            save_and_expire(last_tiddler, last_title,
                            "#{last_tiddler.title} &rarr; #{@tiddler.title}",
                            [], tags, last_tiddler.autolink,
                            last_tiddler.color, tiddlers)
          end
          LesserWiki::Log.rename(@tiddler)
          redirect_to :action => "index", :title => title
        end
      end
    end

    # expire_cache flag is set by HowmChunk::Schedule or HowmChunk::Todo
    last_expire_cache = @tiddler.expire_cache
    @tiddler.expire_cache = false
    @tiddler.render!(EzLinkManager.instance)
    if last_expire_cache != @tiddler.expire_cache
      @tiddler.update_attribute("expire_cache", @tiddler.expire_cache)
    end

    reminder_updated = false
    unless @tiddler.rendered_content.reminders
      @tiddler.reminders.each {|r| r.destroy }
    else
      @tiddler.reminders.each do |r|
        if @tiddler.rendered_content.reminders.select {|e| e.equals(r) }.empty?
          r.destroy
          reminder_updated = true
        end
      end
    end
    if @tiddler.rendered_content.reminders
      @tiddler.rendered_content.reminders.each do |r|
        if @tiddler.reminders.select {|e| e.equals(r) }.empty?
          r.save
          reminder_updated = true
        end
      end
    end

    if reminder_updated
      # expire the cache of the tiddler that contains dynamic content such as
      # Howm schedule
      Tiddler.find(:all, :conditions => "expire_cache = 1").each do |t|
        expire_action :controller => "wiki", :action => "view",
                      :title => t.escaped_title
      end
    end
  end
end
