require 'docdiff'
require 'docdiff/document'
require 'docdiff/view'

class MyDocDiff < DocDiff
  def run(doc1, doc2, resolution, format, digest, option = nil)
    case
    when doc1.class == Document && doc2.class == Document # OK
    when doc1.encoding != nil && doc2.encoding != nil     # OK
    when doc1.encoding == doc2.encoding && doc1.eol == doc2.eol # OK
    else
      raise("Error!  Blame the author (doc1: #{doc1.encoding}, #{doc1.eol}, doc2: #{doc2.encoding}, #{doc2.eol}).")
    end
    
    case resolution
    when "line"; then difference = compare_by_line(doc1, doc2)
    when "word"; then difference = compare_by_line_word(doc1, doc2)
    when "char"; then difference = compare_by_line_word_char(doc1, doc2)
    else
      raise "Unsupported resolution: #{resolution.inspect}"
    end
    view = View.new(difference, doc1.encoding, doc1.eol)
    user_tags = {:start_common        => (@config[:tag_common_start] ||= ''),
      :end_common          => (@config[:tag_common_end] ||= ''),
      :start_del           => (@config[:tag_del_start] ||= ''),
      :end_del             => (@config[:tag_del_end] ||= ''),
      :start_add           => (@config[:tag_add_start] ||= ''),
      :end_add             => (@config[:tag_add_end] ||= ''),
      :start_before_change => (@config[:tag_change_before_start] ||= ''),
      :end_before_change   => (@config[:tag_change_before_end] ||= ''),
      :start_after_change  => (@config[:tag_change_after_start] ||= ''),
      :end_after_change    => (@config[:tag_change_after_end] ||= ''),
      # added 2lines
      :start_position      => (@config[:tag_position_start] ||= ''),
      :end_position      => (@config[:tag_position_end] ||= '')}
    
    case digest
    when true
      case format
      when "tty";      then result = view.to_tty_digest(option)
      when "html";    then result = view.to_html_digest(option)
      when "manued";   then result = view.to_manued_digest(option)
      when "wdiff";    then result = view.to_wdiff_digest(option)
      when "stat";     then result = view.to_stat(option)
      when "user";     then result = view.to_user_digest(user_tags)
      else
        raise "Unsupported output format: #{format.inspect}."
      end
    when false
      case format
      when "tty";      then result = view.to_tty(option)
      when "html";     then result = view.to_html(option)
      when "manued";   then result = view.to_manued(option)
      when "wdiff";    then result = view.to_wdiff(option)
      when "stat";     then result = view.to_stat(option)
      when "user";     then result = view.to_user(user_tags)
      else
        raise "Unsupported output format: #{format.inspect}."
      end
    end
    result.to_s
  end
end
