class AddUsers < ActiveRecord::Migration
  def self.up
    #create_table(:users, { :options => "TYPE=MyISAM" }) do |t|
    create_table :users do |t|
      t.column :login, :string, :limit => 80
      t.column :password, :string, :limit => 40
      t.column :name, :string, :limit => 80
      t.column :email, :string, :limit => 80
      t.column :administrator, :boolean, :default => 0
    end
    execute "alter table users add unique(login)"
    
    execute "alter table tiddlers drop index title" rescue nil # MySQL
    execute "alter table tiddlers drop constraint tiddlers_title_key" rescue nil # PostgreSQL
    add_column :tiddlers, :owner, :integer
    execute "alter table tiddlers add unique(owner, title)"
    
    execute "alter table tags drop index name" rescue nil # MySQL
    execute "alter table tags drop constraint tags_name_key" rescue nil # PostgreSQL
    add_column :tags, :owner, :integer
    execute "alter table tags add unique(owner, name)"
    
    add_column :logs, :owner, :integer
    add_column :logs, :user_id, :integer
  end
  
  def self.down
    remove_column :logs, :user_id
    remove_column :logs, :owner
    
    execute "alter table tags drop index owner" rescue nil # MySQL
    execute "alter table tiddlers drop constraint tiddlers_owner_key" rescue nil # PostgreSQL
    remove_column :tags, :owner
    execute "alter table tags add unique(name)"
    
    execute "alter table tiddlers drop index owner" rescue nil # MySQL
    execute "alter table tags drop constraint tags_owner_key" rescue nil # PostgreSQL
    remove_column :tiddlers, :owner
    execute "alter table tiddlers add unique(title)"
    
    drop_table :users
  end
end
