CREATE TABLE `aliases` (
  `id` bigint(20) unsigned NOT NULL auto_increment,
  `tiddler_id` bigint(20) unsigned NOT NULL default '0',
  `name` varchar(255) binary NOT NULL default '',
  `created_at` datetime default NULL,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

CREATE TABLE `logs` (
  `id` bigint(20) unsigned NOT NULL auto_increment,
  `tiddler_id` bigint(20) unsigned NOT NULL default '0',
  `title` varchar(255) NOT NULL default '',
  `operation` varchar(15) NOT NULL default '',
  `content` text NOT NULL,
  `created_at` datetime default NULL,
  `owner` int(11) default NULL,
  `user_id` int(11) default NULL,
  `auto_link` tinyint(1) default '1',
  `expire_cache` tinyint(1) default '0',
  `color` varchar(15) default NULL,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

CREATE TABLE `reminders` (
  `id` bigint(20) unsigned NOT NULL auto_increment,
  `tiddler_id` bigint(20) unsigned NOT NULL default '0',
  `date` date NOT NULL default '0000-00-00',
  `priority_type` char(1) NOT NULL default '',
  `priority_number` tinyint(4) default NULL,
  `content` varchar(255) NOT NULL default '',
  `created_at` datetime default NULL,
  `updated_at` datetime default NULL,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

CREATE TABLE `schema_info` (
  `version` int(11) default NULL
) TYPE=MyISAM;

CREATE TABLE `settings` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(255) default NULL,
  `value` varchar(255) default NULL,
  PRIMARY KEY  (`id`)
) TYPE=InnoDB;

CREATE TABLE `tags` (
  `id` bigint(20) unsigned NOT NULL auto_increment,
  `name` varchar(255) binary NOT NULL default '',
  `color` varchar(15) default NULL,
  `owner` int(11) default NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `owner` (`owner`,`name`)
) TYPE=MyISAM;

CREATE TABLE `tags_tiddlers` (
  `tiddler_id` bigint(20) unsigned NOT NULL default '0',
  `tag_id` bigint(20) unsigned NOT NULL default '0',
  `created_at` datetime default NULL
) TYPE=MyISAM;

CREATE TABLE `tiddlers` (
  `id` bigint(20) unsigned NOT NULL auto_increment,
  `title` varchar(255) binary NOT NULL default '',
  `content` text NOT NULL,
  `created_at` datetime default NULL,
  `updated_at` datetime default NULL,
  `autolink` tinyint(1) NOT NULL default '0',
  `expire_cache` tinyint(1) NOT NULL default '0',
  `color` varchar(15) default NULL,
  `owner` int(11) default NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `owner` (`owner`,`title`)
) TYPE=MyISAM;

CREATE TABLE `users` (
  `id` int(11) NOT NULL auto_increment,
  `login` varchar(80) default NULL,
  `password` varchar(40) default NULL,
  `name` varchar(80) default NULL,
  `email` varchar(80) default NULL,
  `administrator` tinyint(1) default '0',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `login` (`login`)
) TYPE=InnoDB;

insert into schema_info (version) values (3);
