--
-- Name: aliases; Type: TABLE; Schema: public; Owner: yatsu; Tablespace: 
--

CREATE TABLE aliases (
    id serial NOT NULL,
    tiddler_id integer,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    created_at timestamp without time zone
);


--
-- Name: logs; Type: TABLE; Schema: public; Owner: yatsu; Tablespace: 
--

CREATE TABLE logs (
    id serial NOT NULL,
    tiddler_id integer NOT NULL,
    title character varying(255) DEFAULT ''::character varying NOT NULL,
    operation character varying(15) DEFAULT ''::character varying NOT NULL,
    content text NOT NULL,
    created_at timestamp without time zone,
    "owner" integer,
    user_id integer,
    auto_link boolean DEFAULT true,
    expire_cache boolean DEFAULT false,
    color character varying(15)
);


--
-- Name: reminders; Type: TABLE; Schema: public; Owner: yatsu; Tablespace: 
--

CREATE TABLE reminders (
    id serial NOT NULL,
    tiddler_id integer,
    date date NOT NULL,
    priority_type character(1) DEFAULT ''::bpchar NOT NULL,
    priority_number smallint,
    content character varying(255) DEFAULT ''::character varying NOT NULL,
    created_at timestamp without time zone,
    updated_at timestamp without time zone
);


--
-- Name: schema_info; Type: TABLE; Schema: public; Owner: yatsu; Tablespace: 
--

CREATE TABLE schema_info (
    version integer
);


--
-- Name: settings; Type: TABLE; Schema: public; Owner: yatsu; Tablespace: 
--

CREATE TABLE settings (
    id serial NOT NULL,
    name character varying(255),
    value character varying(255)
);


--
-- Name: tags; Type: TABLE; Schema: public; Owner: yatsu; Tablespace: 
--

CREATE TABLE tags (
    id serial NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    created_at timestamp without time zone,
    updated_at timestamp without time zone,
    "owner" integer
);


--
-- Name: tags_tiddlers; Type: TABLE; Schema: public; Owner: yatsu; Tablespace: 
--

CREATE TABLE tags_tiddlers (
    tiddler_id integer,
    tag_id integer,
    created_at timestamp without time zone
);


--
-- Name: tiddlers; Type: TABLE; Schema: public; Owner: yatsu; Tablespace: 
--

CREATE TABLE tiddlers (
    id serial NOT NULL,
    title character varying(255) DEFAULT ''::character varying NOT NULL,
    content text DEFAULT ''::text NOT NULL,
    autolink smallint DEFAULT 1 NOT NULL,
    color character varying(15),
    expire_cache smallint DEFAULT 0 NOT NULL,
    created_at timestamp without time zone,
    updated_at timestamp without time zone,
    "owner" integer
);


--
-- Name: users; Type: TABLE; Schema: public; Owner: yatsu; Tablespace: 
--

CREATE TABLE users (
    id serial NOT NULL,
    login character varying(80),
    "password" character varying(40),
    name character varying(80),
    email character varying(80),
    administrator boolean DEFAULT false
);


--
-- Name: aliases_pkey; Type: CONSTRAINT; Schema: public; Owner: yatsu; Tablespace: 
--

ALTER TABLE ONLY aliases
    ADD CONSTRAINT aliases_pkey PRIMARY KEY (id);


--
-- Name: logs_pkey; Type: CONSTRAINT; Schema: public; Owner: yatsu; Tablespace: 
--

ALTER TABLE ONLY logs
    ADD CONSTRAINT logs_pkey PRIMARY KEY (id);


--
-- Name: reminders_pkey; Type: CONSTRAINT; Schema: public; Owner: yatsu; Tablespace: 
--

ALTER TABLE ONLY reminders
    ADD CONSTRAINT reminders_pkey PRIMARY KEY (id);


--
-- Name: settings_pkey; Type: CONSTRAINT; Schema: public; Owner: yatsu; Tablespace: 
--

ALTER TABLE ONLY settings
    ADD CONSTRAINT settings_pkey PRIMARY KEY (id);


--
-- Name: tags_owner_key; Type: CONSTRAINT; Schema: public; Owner: yatsu; Tablespace: 
--

ALTER TABLE ONLY tags
    ADD CONSTRAINT tags_owner_key UNIQUE ("owner", name);


--
-- Name: tags_pkey; Type: CONSTRAINT; Schema: public; Owner: yatsu; Tablespace: 
--

ALTER TABLE ONLY tags
    ADD CONSTRAINT tags_pkey PRIMARY KEY (id);


--
-- Name: tiddlers_owner_key; Type: CONSTRAINT; Schema: public; Owner: yatsu; Tablespace: 
--

ALTER TABLE ONLY tiddlers
    ADD CONSTRAINT tiddlers_owner_key UNIQUE ("owner", title);


--
-- Name: tiddlers_pkey; Type: CONSTRAINT; Schema: public; Owner: yatsu; Tablespace: 
--

ALTER TABLE ONLY tiddlers
    ADD CONSTRAINT tiddlers_pkey PRIMARY KEY (id);


--
-- Name: users_login_key; Type: CONSTRAINT; Schema: public; Owner: yatsu; Tablespace: 
--

ALTER TABLE ONLY users
    ADD CONSTRAINT users_login_key UNIQUE (login);


--
-- Name: users_pkey; Type: CONSTRAINT; Schema: public; Owner: yatsu; Tablespace: 
--

ALTER TABLE ONLY users
    ADD CONSTRAINT users_pkey PRIMARY KEY (id);


--
-- Name: aliases_tiddler_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: yatsu
--

ALTER TABLE ONLY aliases
    ADD CONSTRAINT aliases_tiddler_id_fkey FOREIGN KEY (tiddler_id) REFERENCES tiddlers(id);


--
-- Name: reminders_tiddler_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: yatsu
--

ALTER TABLE ONLY reminders
    ADD CONSTRAINT reminders_tiddler_id_fkey FOREIGN KEY (tiddler_id) REFERENCES tiddlers(id);


--
-- Name: tags_tiddlers_tag_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: yatsu
--

ALTER TABLE ONLY tags_tiddlers
    ADD CONSTRAINT tags_tiddlers_tag_id_fkey FOREIGN KEY (tag_id) REFERENCES tags(id);


--
-- Name: tags_tiddlers_tiddler_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: yatsu
--

ALTER TABLE ONLY tags_tiddlers
    ADD CONSTRAINT tags_tiddlers_tiddler_id_fkey FOREIGN KEY (tiddler_id) REFERENCES tiddlers(id);

insert into schema_info (version) values (3);
