var tagArray = [];
var selText = "";

Ajax.WikiUpdater = Class.create();
Ajax.WikiUpdater.prototype = (new Ajax.Base()).extend({
  initialize: function(container, color, name, url) {
    this.name = name;
    this.tiddlerId = "tiddler_" + name;
    this.setOptions(null);
  
    if ($(this.tiddlerId)) {
      scrollToElement(this.tiddlerId);
      $(this.tiddlerId).style.backgroundColor = "#ffffff";
      new Effect.Highlight(this.tiddlerId)
      return;
    }
    
    if (container)
      this.container = container
    else
      this.container = $('tiddlerDummy');
    
    this.options.onComplete = this.loadComplete.bind(this);
    this.options.asynchronous = true;
    
    var html = $('tiddlerTemplate').innerHTML;
    html = html.replace(/\.\.tiddler_id\.\./g, this.tiddlerId).replace(/\.\.title\.\./g, name).replace(/\.\.color\.\./g, color);
    new Insertion.After(this.container, html);
    new Effect.Appear(this.tiddlerId, { duration: 0.5 });
    scrollToElement(this.tiddlerId);
    
    this.request = new Ajax.Request(url, this.options);
  },
  
  loadComplete: function() {
    $(this.tiddlerId).innerHTML = this.request.transport.responseText;
    var tagsid = "tags" + this.name;
    var divid = "tag_name_auto_complete_" + this.name;
    //new Ajax.Autocompleter(tagsid, divid, '/wiki/auto_complete_for_tag_name', { tokens: [" "] });
    tagAutoComplete(tagsid, divid);
    scrollToElement(this.tiddlerId);
    $(this.tiddlerId).style.backgroundColor = "#ffffff";
    new Effect.Highlight(this.tiddlerId);
  }
});

Ajax.TagUpdater = Class.create();
Ajax.TagUpdater.prototype = (new Ajax.Base()).extend({
  initialize: function(name, url) {
    this.tagboxId = "tagArea" + name;
    this.setOptions(null);

    if ($(this.tagboxId)) {
      scrollToElement(this.tagboxId);
      $(this.tagboxId).style.backgroundColor = "#ffffff";
      new Effect.Highlight(this.tagboxId)
      return;
    }
    
    this.container = $('tiddlerDummy');
    this.options.insertion = Insertion.After;
    this.options.onComplete = this.loadComplete.bind(this);
    this.options.asynchronous = true;
    this.request = new Ajax.Request(url, this.options);
  },

  loadComplete: function() {
    if (this.options.insertion) {
      new this.options.insertion(this.container,
        this.request.transport.responseText);
    } else {
      this.container.innerHTML = this.request.transport.responseText;
    }

    new Effect.Appear(this.tagboxId, { duration: 0.5 });
    scrollToElement(this.tagboxId);
    $(this.tagboxId).style.backgroundColor = "#ffffff";
    new Effect.Highlight(this.tagboxId);
  }
});

Ajax.SearchUpdater = Class.create();
Ajax.SearchUpdater.prototype = (new Ajax.Base()).extend({
  initialize: function(search, url) {
    this.searchId = "search" + encodeURIComponent(search);
    this.setOptions(null);

    if ($(this.searchId)) {
      scrollToElement(this.searchId);
      $(this.searchId).style.backgroundColor = "#ffffff";
      new Effect.Highlight(this.searchId)
      if (navigator.userAgent.toLowerCase().indexOf("safari") < 0) {
        $('search').value = "";
        $('search').disabled = false;
      }
      return;
    }

    this.container = $('tiddlerDummy');
    this.options.insertion = Insertion.After;
    this.options.onComplete = this.loadComplete.bind(this);
    this.options.asynchronous = true;

    var html = $('tiddlerSearch').innerHTML;
    new Insertion.After(this.container,
                        html.replace(/\.\.search_escape\.\./g, encodeURIComponent(search)).replace(/\.\.search\.\./g, search));
    new Effect.Appear(this.searchId, { duration: 0.5 });
    scrollToElement(this.searchId);

    this.request = new Ajax.Request(url, this.options);
  },

  loadComplete: function() {
    $(this.searchId).innerHTML = this.request.transport.responseText;
    scrollToElement(this.searchId);
    $(this.searchId).style.backgroundColor = "#ffffff";
    new Effect.Highlight(this.searchId);
    if (navigator.userAgent.toLowerCase().indexOf("safari") < 0) {
      $('search').value = "";
      $('search').disabled = false;
    }
  }
});

function tagAutoComplete(element, update) {
  new Autocompleter.Local(element, update, tagArray, { tokens: [" "] });
}

function showToolbar(title) {
  $('toolbar_' + title).style.visibility = "visible";
}

function hideToolbar(title) {
  $('toolbar_' + title).style.visibility = "hidden";
}

function showTagToolbar(name) {
  $('tagToolbar' + name).style.visibility = "visible";
}

function hideTagToolbar(name) {
  $('tagToolbar' + name).style.visibility = "hidden";
}

function showSearchToolbar(name) {
  $('searchToolbar' + name).style.visibility = "visible";
}

function hideSearchToolbar(name) {
  $('searchToolbar' + name).style.visibility = "hidden";
}

function showViewer(title) {
  Element.show('viewer_' + title);
}

function hideViewer(title) {
  Element.hide('viewer_' + title);
}

function showEditor(title) {
  Element.show('editor_' + title);
}

function hideEditor(title) {
  Element.hide('editor_' + title);
}

function showNormalToolbar(title) {
  Element.show('toolbar_close_' + title);
  Element.show('toolbar_edit_' + title);
  Element.show('toolbar_permalink_' + title);
}

function showEditToolbar(title) {
  Element.show('toolbar_done_' + title);
  Element.show('toolbar_cancel_' + title);
  Element.show('toolbar_delete_' + title);
}

function hideNormalToolbar(title) {
  Element.hide('toolbar_close_' + title);
  Element.hide('toolbar_edit_' + title);
  Element.hide('toolbar_permalink_' + title);
}

function hideEditToolbar(title) {
  Element.hide('toolbar_done_' + title);
  Element.hide('toolbar_cancel_' + title);
  Element.hide('toolbar_delete_' + title);
}

function changeId(title) {
  tiddler = $('tiddler_' + title);
  var newTitle = "";
  for (var i = 0; i < tiddler.childNodes.length; i++) {
    if (tiddler.childNodes[i].id &&
        tiddler.childNodes[i].id.substr(0, 7) == "viewer_") {
      newTitle = tiddler.childNodes[i].id.substr(7);
      tiddler.id = 'tiddler_' + newTitle;
    }
  }
  tiddler.onmouseover = function(e) { showToolbar(newTitle); }
  tiddler.onmouseout = function(e) { hideToolbar(newTitle); }
  return newTitle;
}

function itemLoading(title) {
  hideNormalToolbar(title);
  hideEditToolbar(title);
  
  if ($('loading_' + title)) {
    Element.show('loading_' + title);
    $('loading_' + title).style.margin = "0 0 0 5px";
  }
  
  $('title_' + title).disabled = true;
  $('content_' + title).disabled = true;
  $('autolink' + title).disabled = true;
  $('labelSelect' + title).disabled = true;
  $('aliases' + title).disabled = true;
  $('tags' + title).disabled = true;
  $('submit_' + title).disabled = true;
}

function itemAdded(title) {
  var newTitle = changeId(title);
  if ($('loading_' + newTitle))
    Element.hide('loading_' + newTitle);
  tagAutoComplete("tags" + newTitle, "tag_name_auto_complete_" + newTitle);
}

function editTiddler(title) {
  hideNormalToolbar(title);
  showEditToolbar(title);
  
  hideViewer(title);
  showEditor(title);

  $('content_' + title).focus();
}

function closeTiddler(title) {
  var tiddlerId = 'tiddler_' + title;
  new Effect.Fade(tiddlerId, {
    duration: 0.5,
    afterFinish: function(effect) {
      $(tiddlerId).parentNode.removeChild($(tiddlerId));
    }});
}

function deleteTiddler(title, msg, url) {
  if (confirm(msg)) {
    new Ajax.Request(url, {
      asynchronous: true
    });
    closeTiddler(title);
  }
}

function saveTiddler(title) {
  $('submit_' + title).click()
}

function cancelTiddler(title, state) {
  if (state == 'new') {
    closeTiddler(title);
  } else {
    hideEditToolbar(title);
    showNormalToolbar(title);
    
    hideEditor(title);
    showViewer(title);
  }
}

function closeTagArea(id) {
  var tagId = 'tagArea' + id;
  new Effect.Fade(tagId, {
    duration: 0.5,
    afterFinish: function(effect) {
      $(tagId).parentNode.removeChild($(tagId));
    }});
}

function closeSearch(id) {
  var searchId = 'search' + id;
  new Effect.Fade(searchId, {
    duration: 0.5,
    afterFinish: function(effect) {
      $(searchId).parentNode.removeChild($(searchId));
    }});
}

function closeAllTiddlers() {
  var place = document.getElementById("displayArea");
  var tiddler = place.firstChild;
  var nextTiddler;
  while (tiddler) {
    nextTiddler = tiddler.nextSibling;
    if (tiddler.id) {
      if (tiddler.id.substr(0, 8) == "tiddler_") {
        var title = tiddler.id.substr(8);
        if ($('editor_' + title).style.display == "none")
          place.removeChild(tiddler);
      }
    }
    tiddler = nextTiddler;
  }
}

function closeAllTags() {
  var place = document.getElementById("displayArea");
  var tag = place.firstChild;
  var nextTag;
  while (tag) {
    nextTag = tag.nextSibling;
    if (tag.id) {
      if (tag.id.substr(0, 7) == "tagArea" || tag.id.substr(0, 6) == "search")
        place.removeChild(tag);
    }
    tag = nextTag;
  }
}

function openOptions() {
  //alert("Not implemented yet");
}

function dateString(d) {
  return d.getFullYear() + '-' + (d.getMonth() + 1 < 10 ? '0' : '')
         + (d.getMonth() + 1) + '-' + (d.getDate() < 10 ? '0' : '')
         + d.getDate();
}

function storeSelectedText()
{
  var text = "";
  if (window.getSelection) {
    // Safari, Mozilla
    text = window.getSelection() + "";
  } else if (document.getSelection) {
    // Mozilla
    text = document.getSelection();
  } else if (document.selection) {
    // IE, Opera
    text = document.selection.createRange().text;
  }
  selText = text;
  return text;
}

function escapeSlash(str) {
  return str.replace(/\//g, "  ");
}

function unescapeSlash(str) {
  return str.replace(/  /g, "/");
}

function newTiddler(baseurl) {
  var name = null;
  if (selText && selText.length > 0) {
    name = escapeSlash(selText.replace(/\s+/g, " ").replace(/^\s*(.*)\s*/, "$1"));
  } else {
    name = dateString(new Date());
  }
  var tiddlerId = "tiddler_" + name;
  
  if ($(tiddlerId)) {
    scrollToElement(tiddlerId);
    new Effect.Highlight(tiddlerId)
    return;
  }
  var html = $('tiddlerCreate').innerHTML;
  new Insertion.After($('tiddlerDummy'),
                      html.replace(/\.\.tiddler_id\.\./g, tiddlerId).replace(/\"tiddlerTitleTemplate\"/, '"tiddlerTitle' + name + '"').replace(/\.\.title\.\./g, name));
  tagAutoComplete("tags" + name, "tag_name_auto_complete_" + name);
  new Effect.Appear(tiddlerId, { duration: 0.5 });
  scrollToElement(tiddlerId);
}

var keyEvent=null;
function onKeyDownEvent(e) {
  keyEvent = e;
}
window.onkeydown = onKeyDownEvent;

function onEditKey(title)
{
  var e = window.event;
  var consume = false;

  if (!e) e = keyEvent;

  switch (e.keyCode) {
  case 13: // Ctrl-Enter
  case 10: // Ctrl-Enter on IE PC
  case 77: // Ctrl-Enter is "M" on some platforms
    if (e.ctrlKey) {
      saveTiddler(title);
      consume = true;
    }
    break;
  case 27: // Escape
    cancelTiddler(title, 'view');
    consume = true;
    break;
  }

  e.cancelBubble = consume;
  if (consume)
    if (e.stopPropagation) e.stopPropagation();
  
  return !consume;
}

function onKeySearch(url, msg)
{
  var e = window.event;
  var consume = false;

  if (!e) e = keyEvent;
  var keyCode = e.keyCode;
  
  if (keyCode == 13 || keyCode == 10 || (keyCode == 77 && e.ctrlKey)) {
    onSubmitSearch(url, msg);
    consume = true;
  }
  
  if (navigator.userAgent.toLowerCase().indexOf("safari") >= 0)
    return;

  e.cancelBubble = consume;
  if (consume)
    if (e.stopPropagation) e.stopPropagation();

  return !consume;
}

function onLabelChange(title)
{
  var select = $('labelSelect' + title);
  var color = select.options[select.selectedIndex].value;
  color = color.substr(0, 1).toUpperCase(0) + color.substr(1);
  $('colorBox' + title).className = "colorBox" + color;
}

function onClickTimeline()
{
  Element.hide('tabContentColors');
  Element.hide('tabContentTags');
  Element.show('tabContentTimeline');
}

function onClickColors()
{
  Element.hide('tabContentTimeline');
  Element.hide('tabContentTags');
  Element.show('tabContentColors');
}

function onClickTags()
{
  Element.hide('tabContentTimeline');
  Element.hide('tabContentColors');
  Element.show('tabContentTags');
}

function onClickColor(color)
{
  Element.hide('colorContentNone');
  Element.hide('colorContentRed');
  Element.hide('colorContentOrange');
  Element.hide('colorContentYellow');
  Element.hide('colorContentGreen');
  Element.hide('colorContentBlue');
  Element.hide('colorContentPurple');
  Element.hide('colorContentGray');
  Element.show('colorContent' + color);
}

function showTagsInTiddler(tiddlerId, tagId)
{
  var tagboxId = 'tagBox' + tiddlerId + '-' + tagId;
  if ($(tagboxId).style.display == "none")
    new Effect.Appear(tagboxId, { duration: 0.5 });
  new Effect.Highlight(tagboxId);
}

function hideTagsInTiddler(tiddlerId, tagId)
{
  var tagboxId = 'tagBox' + tiddlerId + '-' + tagId;
  new Effect.Fade(tagboxId, { duration: 0.5 });
}

function showTag(tagId)
{
  var tagboxId = 'tagArea' + tagId;
  if ($(tagboxId).style.display == "none")
    new Effect.Appear(tagboxId, { duration: 0.5 });
  new Effect.Highlight(tagboxId);
}

function hideTag(tagId)
{
  var tagboxId = 'tagArea' + tagId;
  new Effect.Fade(tagboxId, { duration: 0.5 });
}

function onSubmitSearch(url, msg)
{
  var search = $('search').value;
  if (search.length == 0) {
    alert(msg);
    return;
  }
  var enc = url.replace(/\.\.search_escape\.\./g, encodeURIComponent(search)).replace(/\.\.search\.\./g, search);
  if (navigator.userAgent.toLowerCase().indexOf("safari") < 0)
    $('search').disabled = true;
  new Ajax.SearchUpdater(search, enc);
  return;
}

function scrollToElement(id)
{
  window.scrollTo(0, ensureVisible($(id)));
}

function ensureVisible(e)
{
  var posTop = findPosY(e);
  var posBot = posTop + e.offsetHeight;
  var winTop = findScrollY();
  var winHeight = findWindowHeight();
  var winBot = winTop + winHeight;
  if (posTop < winTop)
    return posTop;
  else if (posBot > winBot) {
    if (e.offsetHeight < winHeight)
      return posTop - (winHeight - e.offsetHeight);
    else
      return posTop;
  }
  else
    return winTop;
}

function findWindowHeight()
{
  return window.innerHeight ? window.innerHeight : document.body.clientHeight;
}

function findScrollY()
{
  return window.scrollY ? window.scrollY : document.body.scrollTop;
}

function findPosX(obj)
{
  var curleft = 0;
  if (obj.offsetParent) {
    while (obj.offsetParent) {
      curleft += obj.offsetLeft;
      obj = obj.offsetParent;
    }
  }
  return curleft;
}

function findPosY(obj)
{
  var curtop = 0;
  if (obj.offsetParent) {
    while (obj.offsetParent) {
      curtop += obj.offsetTop;
      obj = obj.offsetParent;
    }
  }
  return curtop;
}

function main(title, array)
{
  tagArray = array;
  if (title)
    tagAutoComplete("tags" + title, "tag_name_auto_complete_" + title);
  
  if ($('search') &&
      navigator.userAgent.toLowerCase().indexOf("safari") >= 0) {
    $('search').setAttribute("type", "search");
    $('search').setAttribute("results", "5");
  }
}
