require File.dirname(__FILE__) + '/../test_helper'

class TiddlerTest < Test::Unit::TestCase
  fixtures :tiddlers, :aliases, :tags, :tags_tiddlers, :reminders, :logs, :users
  
  def setup
    @tiddler = Tiddler.find(1)
  end
  
  def test_first_tiddler
    assert_kind_of Tiddler, @first_tiddler
    assert_equal 1, @first_tiddler.id
    assert_equal "First Tiddler", @first_tiddler.title
    assert_equal "First tiddler's content", @first_tiddler.content
    assert_equal 1, @first_tiddler.autolink
    assert_nil @first_tiddler.color
    assert_equal 1, @first_tiddler.expire_cache
    
    assert_equal 1, @first_tiddler.tags[0].id
    assert_equal "ruby", @first_tiddler.tags[0].name
    assert_equal 2, @first_tiddler.tags[1].id
    assert_equal "rails", @first_tiddler.tags[1].name
  end
  
  def test_escape_slash
    assert_equal "/Slash / Tiddler/", @slash_tiddler.title
    assert_equal "  Slash    Tiddler  ", @slash_tiddler.escaped_title
  end
end
