class Alias < ActiveRecord::Base
  belongs_to :tiddler
  
  # XXX test validations
  validates_length_of :name, :in => 1..40,
                      :too_short => _("error_too_short"),
                      :too_long => _("error_too_long")
  validates_exclusion_of :name,
                         :in => Tiddler.cannot_save_titles,
                         :message => _("error_exclusion")
end
