require 'chunks/wiki'

# Includes the contents of another tiddler for rendering.
# The include command looks like this: "[[!include TiddlerName]]".
# It is a WikiReference since it refers to another tiddler (TiddlerName)
# and the wiki content using this command must be notified
# of changes to that tiddler.
# If the included tiddler could not be found, a warning is displayed.

class Include < WikiChunk::WikiReference

  INCLUDE_PATTERN = /\[\[!include(.*)\]\]\s*/i
  def self.pattern() INCLUDE_PATTERN end


  def initialize(match_data, content)
    super
    @tiddler_name = match_data[1].strip
    @unmask_text = get_unmask_text_avoiding_recursion_loops
  end

  private
  
  def get_unmask_text_avoiding_recursion_loops
    if reftiddler then
      if reftiddler.wiki_includes.include?(@content.tiddler_name)
        # this will break the recursion
        @content.delete_chunk(self)
        reftiddler.clear_display_cache
        return "<em>Recursive include detected; #{@tiddler_name} --> #{@content.tiddler_name} " + 
               "--> #{@tiddler_name}</em>\n"
      else
        @content.merge_chunks(reftiddler.display_content)
        return reftiddler.display_content.pre_rendered 
      end
    else
      return "<em>Could not include #{@tiddler_name}</em>\n"
    end
  end

end
