# This file was ported from typo.
#
# Copyright (c) 2005 Tobias Luetke
#
# Permission is hereby granted, free of charge, to any person obtaining
# a copy of this software and associated documentation files (the
# "Software"), to deal in the Software without restriction, including
# without limitation the rights to use, copy, modify, merge, publish,
# distribute, sublicense, and/or sell copies of the Software, and to
# permit persons to whom the Software is furnished to do so, subject to
# the following conditions:
# 
# The above copyright notice and this permission notice shall be
# included in all copies or substantial portions of the Software.
# 
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
# LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
# OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
# WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

class ConfigManager

  def initialize
    reload
  end

  def is_ok?
    settings.include?("owner_password") and settings.include?("wiki_title")
  end

  def reload
    settings.clear
    Setting.find(:all).each do |line|
      settings[line.name.to_s] = normalize_value(line)
    end
  end
    
  def [](key)
    value = settings[key.to_s]
    (value.nil?) ? Configuration.fields[key.to_s].default : value rescue nil 
  end  

  def self.fields 
    @fields ||= {}
  end

  protected

  class Item < Struct.new(:name, :ruby_type, :default)
  end
  
  def normalize_value(line)
    case (Configuration.fields[line.name.to_s].ruby_type rescue :string)
    when :bool
      (line.value == 'f' or line.value == '0') ? false : true
    when :int
      line.value.to_i
    else
      line.value
    end
  end
    
  def self.setting(name, type, default)
    item = Configuration::Item.new 
    item.name, item.ruby_type, item.default = name, type, default
    fields[item.name.to_s] = item
  end

  def settings
    @hash ||= {}
  end
  
end
