ActionController::Routing::Routes.draw do |map|
  # Add your own custom routes here.
  # The priority is based upon order of creation: first created -> highest priority.
  
  # Here's a sample route:
  # map.connect 'products/:id', :controller => 'catalog', :action => 'view'
  # Keep in mind you can assign values other than :controller and :action

  # You can have the root of your site routed by hooking up '' 
  # -- just remember to delete public/index.html.
  # map.connect '', :controller => "welcome"
  
  map.permalink '/tiddler/:title', :controller => 'wiki', :action => 'index'
  map.tag_permalink '/tag/:name', :controller => 'wiki', :action => 'tag'
  map.search_permalink '/search/:search', :controller => 'wiki', :action => 'search'
  
  map.timeline_page '/timeline_page/:page', :controller => 'wiki', :action => 'timeline_page'
  map.color_page '/color_page/:color/:page', :controller => 'wiki', :action => 'color_page'
  
  map.view_search '/wiki/view_search/:id/:search', :controller => 'wiki', :action => 'view_search'
  
  # Allow downloading Web Service WSDL as a file with an extension
  # instead of a file named 'wsdl'
  map.connect ':controller/service.wsdl', :action => 'wsdl'
  
  # Install the default route as the lowest priority.
  map.connect ':controller/:action/:id'
  
  map.connect '', :controller => 'wiki', :action => 'index'
end
