class AddTiddlerVersion < ActiveRecord::Migration
  def self.up
    drop_table "logs"
    
    add_column "tiddlers", "version", :integer
    
    # used by acts_as_versioned
    create_table "tiddler_versions", :force => true do |t|
      t.column "tiddler_id", :integer
      t.column "title", :string
      t.column "content", :text
      t.column "autolink", :boolean, :default => true, :null => false
      t.column "expire_cache", :boolean, :default => false, :null => false
      t.column "color", :string
      t.column "written_by", :string
      t.column "version", :integer
      t.column "created_at", :datetime
      t.column "updated_at", :datetime
    end
    
    add_index "tiddler_versions", ["tiddler_id", "version"], :name => "tiddler_version_index"
  end

  def self.down
    drop_table "tiddler_versions"
    
    remove_column "tiddlers", "version"
    
    create_table "logs", :force => true do |t|
      t.column "tiddler_id", :integer
      t.column "title", :string
      t.column "operation", :string
      t.column "content", :text
      t.column "auto_link", :boolean, :default => true, :null => false
      t.column "expire_cache", :boolean, :default => false, :null => false
      t.column "color", :string
      t.column "created_at", :datetime
    end
  end
end
