module HTMLElementIdentifier
  def self.included(base)
    base.extend(ClassMethods)
    base.class_eval do
      # instance methods are define here
      
      cattr_reader :html_elements
      
      # Returns all HTML element name that defined by html_element.
      #
      # Example:
      #
      # If HTML elements are define as follows,
      #
      #   html_element :element, "tiddler_"
      #   html_element :toolbar
      #
      # then the result of html_elements is
      #
      #   html_elements => [ "element", "toolbar" ]
      # 
      def html_elements
        elements = {}
        html_elements = self.class.send(:html_elements)
        html_elements.each do |e|
          elements[e] = eval("#{e}_id")
        end
        elements
      end
    end
  end
  
  module ClassMethods
    # class methods are define here
    
    # Define a function to get an HTML element id and a function to get a HTML
    # element's prefix.
    #
    # Example:
    #
    #   html_element :element, "tiddler_"
    #
    # The above description generates following methods.
    #
    #   element_id => "tiddler_" + self.id.to_s
    #   self.element_prefix => "tiddler_"
    #
    # When self.id is null,
    #
    #   element_id => "tiddler_nil"
    def html_element(name, prefix = nil)
      if prefix
        self.class_eval("def #{name}_id; self.id ? '#{prefix}' + self.id.to_s : '#{prefix}nil'; end")
        self.class_eval("def self.#{name}_prefix; '#{prefix}'; end")
      else
        self.class_eval("def #{name}_id; self.id ? '#{name}_' + self.id.to_s : '#{name}_nil'; end")
        self.class_eval("def self.#{name}_prefix; '#{name}_'; end")
      end
            
      self.class_eval("@@html_elements ||= []")
      self.class_eval("@@html_elements << '#{name}'.to_sym")
    end
  end
end