class InitialSchema < ActiveRecord::Migration
  def self.up
    create_table "tiddlers", :force => true do |t|
      t.column "title", :string
      t.column "content", :text
      t.column "autolink", :boolean, :default => false, :null => false
      t.column "expire_cache", :boolean, :default => false, :null => false
      t.column "color", :string
      t.column "created_at", :datetime
      t.column "updated_at", :datetime
    end
    
    create_table "aliases", :force => true do |t|
      t.column "tiddler_id", :integer
      t.column "name", :string
      t.column "created_at", :datetime
    end
    
    create_table "tags", :force => true do |t|
      t.column "name", :string
      t.column "color", :string
    end
    
    create_table "tags_tiddlers", :id => false, :force => true do |t|
      t.column "tiddler_id", :integer
      t.column "tag_id", :integer
      t.column "created_at", :datetime
    end
    
    create_table "reminders", :force => true do |t|
      t.column "tiddler_id", :integer
      t.column "date", :date
      t.column "priority_type", :string
      t.column "priority_number", :integer
      t.column "content", :string
      t.column "created_at", :datetime
      t.column "updated_at", :datetime
    end
    
    create_table "logs", :force => true do |t|
      t.column "tiddler_id", :integer
      t.column "title", :string
      t.column "operation", :string
      t.column "content", :text
      t.column "auto_link", :boolean, :default => true, :null => false
      t.column "expire_cache", :boolean, :default => false, :null => false
      t.column "color", :string
      t.column "created_at", :datetime
    end
  end
  
  def self.down
    drop_table "logs"
    drop_table "reminders"
    drop_table "tags_tiddlers"
    drop_table "tags"
    drop_table "aliases"
    drop_table "tiddlers"
  end
end
