require 'rss/maker'
require 'rss/content'

class RssController < ApplicationController
  
  def index
    v1
  end
  
  # URL parameters:
  #
  # @params['render']
  # when 'on'
  #  -- content will be rendered (*render before comparing)
  # else # (all the other of above)
  #  -- content will not be rendered
  #
  # @params['style']
  # when 'on'
  #  -- link to CSS will be included to output
  # else # (all the other of above)
  #  -- link to CSS will NOT be included to output
  #
  # @params['diff']
  # related to what to be put into content:encoded element.
  # when "line"
  #  -- put diff between last and second last content (resolution: line)
  # when "word"
  #  -- put diff between last and second last content (resolution: word)
  # else # (all the other of above)
  #  --  put last content to content:encoded element
  #
  # @params['digest'] 
  # (it effects only when params['diff'] equals 'line' or 'word')
  # when 'on'
  #  -- use digest mode with docdiff library
  # else # (all the other of above)
  #  -- NOT use digest mode with docdiff library
  def v1
    render_on = (@params["render"] == "on") ? true : false    
    style_on = (@params["style"] == "on") ? true : false
    case @params["diff"]
    when "line"
      diff_style = :line
    when "word"
      diff_style = :word
    else
      diff_style = :none
    end
    digest_on = (@params["digest"] == "on") ? true : false
    
    @tiddlers =
      Tiddler.find(:all, :order => "updated_at desc",
                   :limit => config_values[:rss_limit_display].to_s)

    rss = RSS::Maker.make("1.0") do |maker|
      css = maker.xml_stylesheets.new_xml_stylesheet
      base_url = config_values[:base_url].sub(/\/+\Z/, "")
      css.href = "#{base_url}/stylesheets/wiki.css"
      css.type = "text/css"
      maker.channel.about = "#{base_url}/rss"
      maker.channel.title = config_values[:wiki_title]
      maker.channel.description = config_values[:wiki_description]
      maker.channel.link = base_url
      
      maker.items.do_sort = true
      
      @tiddlers.each do |tiddler|
        item = maker.items.new_item
        item.link = url_for :controller => "wiki", :action => "index", :title => tiddler.title
        item.title = tiddler.title
        item.date = tiddler.updated_at
        
        # diff / render / digest parameters are related to this block
        if diff_style != :none
          # get the current content
          current_content = get_content(tiddler, render_on)
          
          # get the last content
          last_content = ""
          if tiddler.version >= 2
            last_content = get_content(tiddler.versions[tiddler.version - 1],
                                      render_on)
          end

          item.content_encoded = diff_between_contents(last_content, current_content,
                                                       diff_style, digest_on)
        else # diff == :none
          item.content_encoded = get_content(tiddler, render_on)
        end
        
        # style parameter is related to this block
        if style_on
          item.content_encoded =
            %{<link href="#{css.href}" media="screen" rel="Stylesheet" type="#{css.type}" /><pre>#{item.content_encoded}</pre>}
        else
          if render_on
            item.content_encoded = item.content_encoded
          else
            item.content_encoded = "<pre>#{item.content_encoded}</pre>"
          end
        end
      end
    end
    
    @headers["Content-Type"] = 'application/xml; charset=UTF-8'
    render :text => rss, :layout => false
  end
  
  private
  
  def get_content(tiddler, render_on = true)
    if render_on
      tiddler.rendered_content(RSSRenderer.instance)
    else
      tiddler.content
    end
  end
end
