require_dependency 'html_element_identifier'

class SearchResult
  include Reloadable
  
  attr_reader :id, :search, :tiddlers
  
  include HTMLElementIdentifier
  html_element :element, "search_"
  html_element :toolbar, "search_toolbar_"
  html_element :toolbar_close, "search_toolbar_close_"
  html_element :toolbar_close_others, "search_toolbar_close_others_"
  html_element :toolbar_permalink, "search_toolbar_permalink_"
  html_element :handler, "search_handler_"
  html_element :tagging, "search_tagging_"
  
  def initialize(id = 0, search = "", tiddlers = [])
    @id = id
    @search = search
    @tiddlers = tiddlers
  end
end
