class AddUsers < ActiveRecord::Migration
  def self.up
    create_table "users" do |t|
      t.column "login", :string, :limit => 80
      t.column "password", :string, :limit => 40
      t.column "name", :string, :limit => 80
      t.column "email", :string, :limit => 80
      t.column "administrator", :boolean, :default => false
    end
    add_index "users", "login", :unique => true
    
    add_column "tiddlers", "owner", :integer
    add_index "tiddlers", ["owner", "title"], :name => "owner", :unique => true
    
    add_column "tags", "owner", :integer
    add_index "tags", ["owner", "name"], :name => "owner", :unique => true
    
    add_column "logs", "owner", :integer
    add_column "logs", "user_id", :integer
  end
  
  def self.down
    remove_column "logs", "user_id"
    remove_column "logs", "owner"
    
    remove_index "tags", :name => :tags_unique
    remove_column "tags", "owner"
    
    remove_index "tiddlers", :name => :tiddlers_unique
    remove_column "tiddlers", "owner"
    
    drop_table "users"
  end
end
