# This file is autogenerated. Instead of editing this file, please use the
# migrations feature of ActiveRecord to incrementally modify your database, and
# then regenerate this schema definition.

ActiveRecord::Schema.define(:version => 9) do

  create_table "aliases", :force => true do |t|
    t.column "tiddler_id", :integer, :limit => 20, :default => 0, :null => false
    t.column "name", :string, :default => "", :null => false
    t.column "created_at", :datetime
  end

  add_index "aliases", ["name"], :name => "aliases_name_index"

  create_table "reminders", :force => true do |t|
    t.column "tiddler_id", :integer, :limit => 20, :default => 0, :null => false
    t.column "date", :date, :null => false
    t.column "priority_type", :string, :limit => 1, :default => "", :null => false
    t.column "priority_number", :integer, :limit => 4
    t.column "content", :string, :default => "", :null => false
    t.column "created_at", :datetime
    t.column "updated_at", :datetime
  end

  create_table "settings", :force => true do |t|
    t.column "name", :string
    t.column "value", :string
  end

  create_table "taggings", :force => true do |t|
    t.column "taggable_id", :integer, :limit => 20
    t.column "tag_id", :integer, :limit => 20, :default => 0, :null => false
    t.column "created_at", :datetime
    t.column "taggable_type", :string
  end

  add_index "taggings", ["taggable_id", "taggable_type", "tag_id"], :name => "taggings_index"

  create_table "tags", :force => true do |t|
    t.column "name", :string, :default => "", :null => false
  end

  add_index "tags", ["name"], :name => "tags_unique", :unique => true

  create_table "tiddler_versions", :force => true do |t|
    t.column "tiddler_id", :integer
    t.column "title", :string
    t.column "content", :text
    t.column "autolink", :boolean, :default => true, :null => false
    t.column "expire_cache", :boolean, :default => false, :null => false
    t.column "color", :string
    t.column "written_by", :string
    t.column "version", :integer
    t.column "created_at", :datetime
    t.column "updated_at", :datetime
  end

  add_index "tiddler_versions", ["tiddler_id", "version"], :name => "tiddler_version_index"

  create_table "tiddlers", :force => true do |t|
    t.column "title", :string, :default => "", :null => false
    t.column "content", :text, :default => "", :null => false
    t.column "created_at", :datetime
    t.column "updated_at", :datetime
    t.column "autolink", :boolean, :default => false, :null => false
    t.column "expire_cache", :boolean, :default => false, :null => false
    t.column "color", :string, :limit => 15
    t.column "written_by", :string
    t.column "version", :integer
  end

  add_index "tiddlers", ["title"], :name => "tiddler_title_unique", :unique => true

end
