var userAgent = navigator.userAgent.toLowerCase();
var browser = {
  isIE: userAgent.indexOf("msie") != -1 && userAgent.indexOf("opera") == -1,
  isSafari: userAgent.indexOf("applewebkit") != -1,
  isBadSafari: !((new RegExp("[\u0150\u0170]","g")).test("\u0150")),
  isLinux: userAgent.indexOf("linux") != -1,
  isUnix: userAgent.indexOf("x11") != -1,
  isMac: userAgent.indexOf("mac") != -1,
  isWindows: userAgent.indexOf("win") != -1
};

function stopEvent(event) {
  event.cancelBubble = true;
  if (event.stopPropagation) event.stopPropagation();
}

function scrollToElement(id) {
  window.scrollTo(0, ensureVisible($(id)));
}

function ensureVisible(e) {
  var posTop = findPosY(e);
  var posBot = posTop + e.offsetHeight;
  var winTop = findScrollY();
  var winHeight = findWindowHeight();
  var winBot = winTop + winHeight;
  if (posTop < winTop)
    return posTop;
  else if (posBot > winBot) {
    if (e.offsetHeight < winHeight)
      return posTop - (winHeight - e.offsetHeight);
    else
      return posTop;
  }
  else
    return winTop;
}

function findWindowHeight() {
  return window.innerHeight ? window.innerHeight : document.body.clientHeight;
}

function findScrollY() {
  return window.scrollY ? window.scrollY : document.body.scrollTop;
}

function findPosX(obj) {
  var curleft = 0;
  if (obj.offsetParent) {
    while (obj.offsetParent) {
      curleft += obj.offsetLeft;
      obj = obj.offsetParent;
    }
  }
  return curleft;
}

function findPosY(obj) {
  var curtop = 0;
  if (obj.offsetParent) {
    while (obj.offsetParent) {
      curtop += obj.offsetTop;
      obj = obj.offsetParent;
    }
  }
  return curtop;
}

function closeAllTiddlers() {
  var elements = document.getElementsByClassName("tiddler", $("tiddler_display"));
  for (var i = 0; i < elements.length; i++) {
    var editor = document.getElementsByClassName("editor_parent", elements[i]);
    if (editor.length == 0 /* tag */ ||
        (Element.visible(elements[i]) &&
        editor.length > 0 && !Element.visible(editor[0]))) {
      elements[i].finalize();
      Element.remove(elements[i]);
    }
  }
}

function enableForm(editor_id) {
  if (!$(editor_id)) return;
  
  var elements = $(editor_id).parentNode.getElementsByTagName("img");
  if (elements.length >= 1)
    Element.hide(elements[0]);
  
  elements = $(editor_id).getElementsByTagName("input");
  for (var i = 0; i < elements.length; i++) {
    if (elements[i].type == "text")
      elements[i].disabled = false;
  }
  
  elements = $(editor_id).getElementsByTagName("textarea");
  for (var i = 0; i < elements.length; i++) {
    elements[i].disabled = false;
    elements[i].focus();
    elements[i].select();
  }
  
  elements = $(editor_id).getElementsByTagName("select");
  for (var i = 0; i < elements.length; i++)
    elements[i].disabled = false;
}

function colorBoxChange(colorbox, select) {
  var color = $(select).options[$(select).selectedIndex].value;
  $(colorbox).className = "colorbox colorbg_" + color;
}

/*
  JSON data format is as follows
  
    current_tiddler: "..."
    new_tiddler: "..."
    title: "..."
    color: "..."
    url: "/wiki/view/..."
*/
function openTiddler(json_data) {
  var values = json_data.parseJSON();
  
  if (!$(values["new_tiddler"])) {
    new Ajax.LoadingUpdater('tiddler_template', values["current_tiddler"],
      {
        element_id: values["new_tiddler"],
        title: values["title"],
        color: values["color"]
      },
      function(request) {
        new Effect.Appear($(values["new_tiddler"]), {
          duration: 0.5,
          afterUpdate: function(effect) {
            scrollToElement($(values["new_tiddler"]));
          }
        });
      },
      values["url"],
      {
        asynchronous: true, evalScripts: true, insertion: Insertion.After,
        onComplete: function(request) {
          scrollToElement($(values["new_tiddler"]));
          new Effect.SafeHighlight($(values["new_tiddler"]));
        }
      }
    );
  }
  else {
    scrollToElement($(values["new_tiddler"]));
    new Effect.SafeHighlight($(values["new_tiddler"]));
  };
}

/*
  JSON data format is as follows
  
    current_tiddler: "..."
    tag_element: "..."
    tag_name: "..."
    url: "/wiki/view_tag/..."
*/
function openTag(json_data) {
  var values = json_data.parseJSON();
  
  if (!$(values["tag_element"])) {
    new Ajax.LoadingUpdater('tag_template', values["current_tiddler"],
      {
        element_id: values["tag_element"],
        name: values["tag_name"]
      },
      function(request) {
        new Effect.Appear($(values["tag_element"]), {
          duration: 0.5,
          afterUpdate: function(effect) {
            scrollToElement($(values["tag_element"]));
          }
        });
      },
      values["url"],
      {
        asynchronous: true, evalScripts: true, insertion: Insertion.After,
        onComplete: function(request) {
          scrollToElement($(values["tag_element"]));
          new Effect.SafeHighlight($(values["tag_element"]));
        }
      }
    );
  }
  else {
    scrollToElement($(values["tag_element"]));
    new Effect.SafeHighlight($(values["tag_element"]));
  };
}

/*
  JSON data format is as follows
  
    current_tiddler: "..."
    element: "..."
    search: "..."
    url: "/wiki/search/..."
*/
function openSearch(json_data) {
  var values = json_data.parseJSON();
  
  if (!$(values["element"])) {
    new Ajax.LoadingUpdater('search_template', values["current_tiddler"],
      {
        element_id: values["element"],
        search: values["search"]
      },
      function(request) {
        new Effect.Appear($(values["element"]), {
          duration: 0.5,
          afterUpdate: function(effect) {
            scrollToElement($(values["element"]));
          }
        });
      },
      values["url"],
      {
        asynchronous: true, evalScripts: true, insertion: Insertion.After,
        onComplete: function(request) {
          scrollToElement($(values["element"]));
          new Effect.SafeHighlight($(values["element"]));
        }
      }
    );
  }
  else {
    scrollToElement($(values["element"]));
    new Effect.SafeHighlight($(values["element"]));
  };
}

function nonexistingTiddler(title) {
  command_panel_handler.onNew(title);
}

/* 
   Unfortunately, Effect.Highlight() keeps in-between color when many
   highlights are started in a lump, so set the background color to white
   before the effect is started (although there may be more sophisticated
   ways...).
*/
Effect.SafeHighlight = Class.create();
Object.extend(Object.extend(Effect.SafeHighlight.prototype, Effect.Highlight.prototype), {
  initialize: function(element) {
    this.element = $(element);
    var options = Object.extend({ startcolor: '#ffff99',
                                  beforeSetup: function(effect) {
                                    effect.element.style.backgroundColor = "#ffffff";
                                  }}, arguments[1] || {});
    this.start(options);
  }
});

Ajax.LoadingUpdater = Class.create();
Ajax.LoadingUpdater.prototype = Object.extend(new Ajax.Base(), {
  initialize: function(template, container, values, loadingEffect, url, options) {
    this.setOptions(options);
    
    this.updater = {};
    
    this.template = template;
    this.container = container;
    this.values = values;
    this.url = url;
    
    this.loadingEffect = loadingEffect;
    
    this.onComplete = this.options.onComplete;
    
    this.options.onComplete = this.onComplete.bind(this);
    
    this.insertion = this.options.insertion;
    this.options.insertion = undefined;
    
    this.onLoading();
    
    this.request = new Ajax.Request(this.url, this.options);
  },
  
  onLoading: function() {
    var temp = new Template($(this.template).innerHTML,
                            /(^|.|\r|\n)(\$\{(.*?)\})/);
    var html = temp.evaluate(this.values);
    
    if (this.insertion)
      new this.insertion(this.container, html);
    else
      Element.update(this.container, html);
    
    if (this.loadingEffect)
      this.loadingEffect();
  },
  
  onComplete: function(request) {
    if (this.onComplete)
      setTimeout(this.onComplete.bind(this), 10);
  }
});

CommandPanelHandler = Class.create();
CommandPanelHandler.prototype = {
  initialize: function(searchUrl) {
    this.searchUrl = searchUrl;
    this.selText = "";
    this.searchId = 1;
    
    Event.observe("command_new", "mouseover",
                  this.onMouseOver.bindAsEventListener(this));
    Event.observe("search", "keypress",
                  this.onKeyPress.bindAsEventListener(this));
  },
  
  onMouseOver: function(event) {
    if (window.getSelection) // Safari, Mozilla
      this.selText = window.getSelection() + "";
    else if (document.getSelection) // Mozilla
      this.selText = document.getSelection();
    else if (document.selection) // IE, Opera
      this.selText = document.selection.createRange().text;
  },
  
  onKeyPress: function(event) {
    var consume = false;
    
    if (!event) event = keyEvent;
    var keyCode = event.keyCode;
    
    if (keyCode == 13 || keyCode == 10 || (keyCode == 77 && event.ctrlKey)) {
      this.search();
      consume = true;
    }
    
    if (browser.isSafari) return;
    
    event.cancelBubble = consume;
    if (consume) {
      if (event.stopPropagation)
        event.stopPropagation();
    }
    
    return !consume;
  },
  
  onNew: function(title) {
    $("form_0").reset();
    Element.hide("loading_0");
    colorBoxChange($("colorbox_0"), $("color_select_0"));
    this.enableForm();
    
    if (title)
      $("editor_title_0").value = title;
    else
      $("editor_title_0").value = this.selText;
    
    this.focusForm();
  },
  
  onCloseAll: function() {
    closeAllTiddlers();
  },
  
  onSearch: function() {
    this.search();
  },
  
  onLogin: function() {
    if (Element.visible("login_panel"))
      new Effect.BlindUp("login_panel", { duration: 0.3 });
    else
      new Effect.BlindDown("login_panel", { duration: 0.3 });
  },
  
  enableForm: function() {
    enableForm("editor_0");
  },
  
  focusForm: function() {
    if (Element.visible("tiddler_0")) {
      new Effect.Highlight("tiddler_0");
      $("editor_title_0").focus();
      $("editor_title_0").select();
    }
    else {
      new Effect.Appear("tiddler_0", {
        duration: 0.5,
        afterFinish: function(effect) {
          $("editor_title_0").focus();
          $("editor_title_0").select();
        }
      });
    }
  },
  
  search: function() {
    str = $("search").value;
    if (str.length == 0) return;
    
    if (!browser.isSafari)
      $("search").disabled = true;
    
    var jsonObj = {
      current_tiddler: "tiddler_0",
      element: "search_" + this.searchId,
      search: str.escapeHTML(),
      url: this.searchUrl + "/" + this.searchId + "/" + encodeURIComponent(str)
    };
    
    openSearch(jsonObj.toJSONString());
    
    this.searchId++;
  },
  
  searchDone: function() {
    if (!browser.isSafari)
      $("search").disabled = false;
    
    $("search").value = "";
  }
}

AbstractToolbar = Class.create();
AbstractToolbar.prototype = {
  initialize: function() {
    this.elements = {};
  },
  
  finalize: function(event) {
  },
  
  onClose: function(event) {
    var element_id = this.elements["element"];
    new Effect.Fade(element_id, {
                      duration: 0.5,
                      afterFinish: function(effect) {
                        if ($(element_id)) $(element_id).finalize();
                        Element.remove(element_id);
                      }});
  },
  
  onCloseOthers: function(event) {
    var elements = document.getElementsByClassName("tiddler", $(this.elements["element"]).parentNode)
    for (var i = 0; i < elements.length; i++) {
      var editor = document.getElementsByClassName("editor_parent", elements[i]);
      if (elements[i] != $(this.elements["element"]) &&
          (editor.length == 0 /* tag */ ||
           (Element.visible(elements[i]) &&
            editor.length > 0 && !Element.visible(editor[0])))) {
        elements[i].finalize();
        Element.remove(elements[i]);
      }
    }
  },
  
  onPermalink: function(permalink_url) {
    window.open(this.permalink_url, "_blank");
  }
}

TagToolbar = Class.create();  
Object.extend(TagToolbar.prototype, AbstractToolbar.prototype);
Object.extend(TagToolbar.prototype, {
  initialize: function(permalink_url, elements) {
    this.permalink_url = permalink_url;
    this.elements = elements;
    
    this.mouseOverListener = this.focusIn.bindAsEventListener(this);
    Event.observe(this.elements["element"], "mouseover",
                  this.mouseOverListener);
    
    this.mouseOutListener = this.focusOut.bindAsEventListener(this);
    Event.observe(this.elements["element"], "mouseout",
                  this.mouseOutListener);
    
    this.closeListener = this.onClose.bindAsEventListener(this);
    Event.observe(this.elements["toolbar_close"], "click",
                  this.closeListener);
    
    this.closeOthersListener = this.onCloseOthers.bindAsEventListener(this);
    Event.observe(this.elements["toolbar_close_others"], "click",
                  this.closeOthersListener);
    
    this.permalinkListener = this.onPermalink.bindAsEventListener(this);
    Event.observe(this.elements["toolbar_permalink"], "click",
                  this.permalinkListener);
    
    $(this.elements["element"]).finalize = this.finalize.bind(this);
  },
  
  finalize: function() {
    Event.stopObserving(this.elements["element"], "mouseover",
                        this.mouseOverListener);
    Event.stopObserving(this.elements["element"], "mouseout",
                        this.mouseOutListener);
    Event.stopObserving(this.elements["toolbar_close"], "click",
                        this.closeListener);
    Event.stopObserving(this.elements["toolbar_close_others"], "click",
                        this.closeOthersListener);
    Event.stopObserving(this.elements["toolbar_permalink"], "click",
                        this.permalinkListener);
  },
  
  focusIn: function(event) {
    $(this.elements["toolbar"]).style.visibility = "visible";    
    Element.addClassName(this.elements["element"], "selected");
  },
  
  focusOut: function(event) {
    $(this.elements["toolbar"]).style.visibility = "hidden";
    Element.removeClassName(this.elements["element"], "selected");
  }
});

NewTiddlerToolbar = Class.create();  
Object.extend(NewTiddlerToolbar.prototype, AbstractToolbar.prototype);
Object.extend(NewTiddlerToolbar.prototype, {
  initialize: function(listener, elements) {
    this.listener = listener;
    this.elements = elements;
    
    this.doneListener = this.onDone.bindAsEventListener(this);
    Event.observe(this.elements["toolbar_done"], "click",
                  this.doneListener);
    this.cancelListener = this.onCancel.bindAsEventListener(this);
    Event.observe(this.elements["toolbar_cancel"], "click",
                  this.cancelListener);
  },
  
  finalize: function() {
    Event.stopObserving(this.elements["toolbar_done"], "click",
                        this.doneListener);
    Event.stopObserving(this.elements["toolbar_cancel"], "click",
                        this.cancelListener);
  },
  
  onDone: function(event) {
    if ($(this.elements["editor_title"]).getAttribute("readonly") == "readonly") {
      this.onCancel(event);
    }
    else {
      // disable "done" and "delete"
      Element.hide(this.elements["toolbar_done"]);
      Element.hide(this.elements["toolbar_delete"]);
      
      // submit the form
      $(this.elements["editor_submit"]).click();
    }
  },
  
  onCancel: function(event) {
    $(this.elements["form"]).reset();
    Element.hide(this.elements["loading"]);
    colorBoxChange(this.elements["colorbox"], this.elements["color_select"]);
    new Effect.Fade(this.elements["element"], { duration: 0.5 });
  }
});

TiddlerToolbar = Class.create();
Object.extend(TiddlerToolbar.prototype, NewTiddlerToolbar.prototype);
Object.extend(TiddlerToolbar.prototype, {
  initialize: function(listener, elements, permalink_url, delete_url, delete_confirm) {
    this.listener = listener;
    this.elements = elements;
    this.permalink_url = permalink_url;
    this.delete_url = delete_url;
    this.delete_confirm = delete_confirm;
    
    this.closeListener = this.onClose.bindAsEventListener(this);
    Event.observe(this.elements["toolbar_close"], "click",
                  this.closeListener);
                  
    this.closeOthersListener = this.onCloseOthers.bindAsEventListener(this);
    Event.observe(this.elements["toolbar_close_others"], "click",
                  this.closeOthersListener);
    
    if ($(this.elements["toolbar_edit"])) {
      this.editListener = this.onEdit.bindAsEventListener(this);
      Event.observe(this.elements["toolbar_edit"], "click",
                    this.editListener);
    }

    if ($(this.elements["toolbar_permalink"])) {
      this.permalinkListener = this.onPermalink.bindAsEventListener(this);
      Event.observe(this.elements["toolbar_permalink"], "click",
                    this.permalinkListener);
    }

    if ($(this.elements["toolbar_done"])) {
      this.doneListener = this.onDone.bindAsEventListener(this);
      Event.observe(this.elements["toolbar_done"], "click",
                    this.doneListener);
    }

    if ($(this.elements["toolbar_cancel"])) {
      this.cancelListener = this.onCancel.bindAsEventListener(this);
      Event.observe(this.elements["toolbar_cancel"], "click",
                    this.cancelListener);
    }

    if ($(this.elements["toolbar_delete"])) {
      this.deleteListener = this.onDelete.bindAsEventListener(this);
      Event.observe(this.elements["toolbar_delete"], "click",
                    this.deleteListener);
    }
  },
  
  finalize: function() {
    Event.stopObserving(this.elements["toolbar_close"], "click",
                        this.closeListener);
    Event.stopObserving(this.elements["toolbar_close_others"], "click",
                        this.closeOthersListener);
    if (this.editListener)
      Event.stopObserving(this.elements["toolbar_edit"], "click",
                          this.editListener);
    if (this.permalinkListener)
      Event.stopObserving(this.elements["toolbar_permalink"], "click",
                          this.permalinkListener);
    if (this.doneListener)
      Event.stopObserving(this.elements["toolbar_done"], "click",
                          this.doneListener);
    if (this.cancelListener)
      Event.stopObserving(this.elements["toolbar_cancel"], "click",
                          this.cancelListener);
    if (this.deleteListener)
      Event.stopObserving(this.elements["toolbar_delete"], "click",
                          this.deleteListener);
  },
  
  onEdit: function(event) {
    this.listener.edit();
  },
  
  onCancel: function(event) {
    $(this.elements["form"]).reset();
    colorBoxChange(this.elements["colorbox"], this.elements["color_select"]);
    this.listener.view();
  },
  
  onDelete: function(event) {
    if (confirm(this.delete_confirm)) {
      new Ajax.Request(this.delete_url, { asynchronous: true });
      
      var element_id = this.elements["element"];
      new Effect.Fade(element_id, {
                        duration: 0.5,
                        afterFinish: function(effect) {
                          if ($(element_id)) $(element_id).finalize();
                          Element.remove(element_id);
                        }});
    }
  }
});

NewTiddlerEventListener = Class.create();
NewTiddlerEventListener.prototype = {
  initialize: function(elements) {
    this.elements = elements;
    this.toolbar = new NewTiddlerToolbar(this, elements);
    
    this.mouseOverListener = this.focusIn.bindAsEventListener(this);
    Event.observe(this.elements["element"], "mouseover",
                  this.mouseOverListener);
    
    this.mouseOutListener = this.focusOut.bindAsEventListener(this);
    Event.observe(this.elements["element"], "mouseout",
                  this.mouseOutListener);
    
    this.keyPressListener = this.keyPress.bindAsEventListener(this);
    Event.observe(this.elements["editor"], "keypress",
                  this.keyPressListener);

    this.submitListener = this.onSubmit.bindAsEventListener(this);
    Event.observe(this.elements["form"], "submit",
                  this.submitListener);
    
    $(this.elements["element"]).finalize = this.finalize.bind(this);
  },
  
  finalize: function() {
    Event.stopObserving(this.elements["element"], "mouseover",
                        this.mouseOverListener);
    Event.stopObserving(this.elements["element"], "mouseout",
                        this.mouseOutListener);
    Event.stopObserving(this.elements["editor"], "keypress",
                        this.keyPressListener);
    Event.stopObserving(this.elements["form"], "submit",
                        this.submitListener);
    delete this.toolbar;
  },
  
  focusIn: function(event) {
    $(this.elements["toolbar"]).style.visibility = "visible";
  },
  
  focusOut: function(event) {
    $(this.elements["toolbar"]).style.visibility = "hidden";
  },
  
  keyPress: function(event) {
    var consume = false;

    switch (event.keyCode) {
    case 13: // Ctrl-Enter
    case 10: // Ctrl-Enter on IE PC
    case 77: // Ctrl-Enter is "M" on some platforms
      if (event.ctrlKey) {
        this.toolbar.onDone();
        consume = true;
      }
      break;
    case 27: // Escape
      this.toolbar.onCancel();
      consume = true;
      break;
    }

    event.cancelBubble = consume;
    if (consume) {
      if (event.stopPropagation)
        event.stopPropagation();
    }
  },
  
  onSubmit: function(event) {    
    // show spinner
    Element.show(this.elements["loading"]);
    
    // disable input fields
    var elements = $(this.elements["editor"]).getElementsByTagName("input");
    for (var i = 0; i < elements.length; i++) {
      if (elements[i].type == "text")
        elements[i].disabled = true;
    }
    
    // disable textareas
    elements = $(this.elements["editor"]).getElementsByTagName("textarea");
    for (var i = 0; i < elements.length; i++)
      elements[i].disabled = true;
    
    // disable select boxes
    elements = $(this.elements["editor"]).getElementsByTagName("select");
    for (var i = 0; i < elements.length; i++)
      elements[i].disabled = true;
  }
}

TiddlerEventListener = Class.create();
Object.extend(TiddlerEventListener.prototype, NewTiddlerEventListener.prototype);
Object.extend(TiddlerEventListener.prototype, {
  initialize: function(permalink_url, delete_url, delete_confirm, elements) {
    this.elements = elements;
    this.toolbar = new TiddlerToolbar(this, elements, permalink_url,
                                      delete_url, delete_confirm);
    
    this.mouseOverListener = this.focusIn.bindAsEventListener(this);
    Event.observe(this.elements["element"], "mouseover",
                  this.mouseOverListener);
    
    this.mouseOutListener = this.focusOut.bindAsEventListener(this);
    Event.observe(this.elements["element"], "mouseout",
                  this.mouseOutListener);
    
    this.submitListener = this.onSubmit.bindAsEventListener(this);
    Event.observe(this.elements["form"], "submit",
                  this.submitListener);
    
    if (this.elements["element"].match(/\d$/)) {
      if (browser.isSafari) { // Safari does not respond to 'dblclick'
        this.dblClickListener = this.toggleSafari.bindAsEventListener(this);
        Event.observe(this.elements["element"], "click",
                      this.dblClickListener);
      }
      else {
        this.dblClickListener = this.toggle.bindAsEventListener(this);
        Event.observe(this.elements["element"], "dblclick",
                      this.dblClickListener);
      }
    }
    
    this.keyPressListener = this.keyPress.bindAsEventListener(this);
    Event.observe(this.elements["editor"], "keypress",
                  this.keyPressListener);

    $(this.elements["element"]).finalize = this.finalize.bind(this);
  },
  
  finalize: function() {
    Event.stopObserving(this.elements["element"], "mouseover",
                        this.mouseOverListener);
    Event.stopObserving(this.elements["element"], "mouseover",
                        this.mouseOutListener);
    Event.stopObserving(this.elements["editor"], "keypress",
                        this.keyPressListener);
    Event.stopObserving(this.elements["form"], "submit",
                        this.submitListener);
    
    if (browser.isSafari) // Safari does not respond to 'dblclick'
      Event.stopObserving(this.elements["element"], "click",
                          this.dblClickListener);
    else
      Event.stopObserving(this.elements["element"], "dblclick",
                          this.dblClickListener);
    delete this.toolbar;
  },
  
  focusIn: function(event) {
    $(this.elements["toolbar"]).style.visibility = "visible";
    Element.addClassName(this.elements["element"], "selected");
  },
  
  focusOut: function(event) {
    $(this.elements["toolbar"]).style.visibility = "hidden";
    Element.removeClassName(this.elements["element"], "selected");
  },
  
  edit: function(event) {
    // hide viewer
    Element.hide(this.elements["subtitle"]);
    Element.hide(this.elements["viewer"]);
    Element.hide(this.elements["tagged"]);
    
    // show editor
    Element.show(this.elements["editor"]);
    
    // switch toolbar
    this.switchToolbar("edit_toolbar");
    
    $(this.elements["editor_content"]).focus();
    $(this.elements["editor_content"]).select();
  },
  
  toggle: function(event) {
    if (Element.visible(this.elements["editor"])) {
      $(this.elements["form"]).reset();
      colorBoxChange(this.elements["colorbox"], this.elements["color_select"]);
      this.view(event);
    }
    else
      this.edit(event);
  },
  
  toggleSafari: function(event) {
    if (event.detail == 2)
      this.toggle(event);
  },
  
  view: function(event) {
    // hide editor
    Element.hide(this.elements["editor"]);
    
    // show viewer
    Element.show(this.elements["subtitle"]);
    Element.show(this.elements["viewer"]);
    Element.show(this.elements["tagged"]);
    
    // switch toolbar
    this.switchToolbar("view_toolbar");
  },
  
  switchToolbar: function(klass) {
    var elements = $(this.elements["toolbar"]).getElementsByTagName("a");
    for (var i = 0; i < elements.length; i++) {
      if (elements[i].className.match(klass))
        Element.show(elements[i]);
      else
        Element.hide(elements[i]);
    }
  }
});

SidebarTabsHandler = Class.create();
SidebarTabsHandler.prototype = {
  initialize: function() {
    this.tabs = [ "timeline", "colors", "tags" ];
    
    Event.observe("tab_timeline", "click",
                  this.onClickTimeline.bindAsEventListener(this));
    Event.observe("tab_colors", "click",
                  this.onClickColors.bindAsEventListener(this));
    Event.observe("tab_tags", "click",
                  this.onClickTags.bindAsEventListener(this));
  },
  
  onClickTimeline: function(event) {
    this.selectTab("timeline");
  },
  
  onClickColors: function(event) {
    this.selectTab("colors");
  },
  
  onClickTags: function(event) {
    this.selectTab("tags");
  },
  
  selectTab: function(select) {
    this.tabs.each(function(tab, index) {
      if (tab == select) {
        Element.removeClassName("tab_" + tab, "tab_unselected");
        Element.addClassName("tab_" + tab, "tab_selected");
        
        Element.show("sidebar_" + tab);
      }
      else {
        Element.removeClassName("tab_" + tab, "tab_selected");
        Element.addClassName("tab_" + tab, "tab_unselected");
        
        Element.hide("sidebar_" + tab);
      }
    });
  }
}

ColorTabHandler = Class.create();
ColorTabHandler.prototype = {
  initialize: function(color, parent) {
    this.color = color;
    this.parent = parent;
    this.clickListener =
      Event.observe("sidebar_color_" + color, "click",
                    this.onClick.bindAsEventListener(this));
  },
  
  onClick: function(event) {
    this.parent.selectColor(this.color, event);
  },
  
  finalize: function() {
    Event.stopObserving($("sidebar_color_" + color), "click",
                        this.clickListener);
  }
}

ColorTabsHandler = Class.create();
ColorTabsHandler.prototype = {
  initialize: function(colors, urlPrefix) {
    this.colors = colors;
    this.urlPrefix = urlPrefix;
    
    var handlers = [];
    var parent = this;
    this.colors.each(function(color, index) {
      handlers.push(new ColorTabHandler(color, parent));
    });
    this.handlers = handlers;  
  },
  
  selectColor: function(select, event) {
    // change CSS classes
    this.colors.each(function(color, index) {
      if (color == select) {
        Element.removeClassName("sidebar_color_" + color, "color_tab_unselected");
        Element.addClassName("sidebar_color_" + color, "color_tab_selected");
      }
      else {
        Element.removeClassName("sidebar_color_" + color, "colorr_tab_selected");
        Element.addClassName("sidebar_color_" + color, "color_tab_unselected");
      }
    });
    
    new Ajax.Request(this.urlPrefix + select + "/1", { asynchronous: true });
  },
  
  finalize: function() {
    this.handlers.each(function(handler, index) {
      handler.finalize();
      delete handler;
    });
  }
}
