/*
* See the file LICENSE for redistribution information.
*
* Copyright: 2010- 1stclass.co.jp.  All rights reserved.
*
* Created by Hajime Kurita
*/
#include <limits.h>
#include <stdlib.h>

#ifdef __cplusplus
#include "1stclass.hpp"

string firstclass::rel2abs(const string in_rel_path){
  char rel_path[2048]="";;
  safe_strcat(rel_path, in_rel_path.c_str(), sizeof(rel_path));
  char abs_path[2048]="";
#else
#include "1stclass.h"
int rel2abs(const char *rel_path, char *abs_path){
#endif
  if(rel_path[0]=='/'){
    safe_strcat(abs_path, rel_path, 2048);
  }
  else if(rel_path[0]=='.'){
    char in_real[512]="";
    char tail[2048]="";
    int found=0;
    int found_i=0;
    int i=0;
    int tail_i=0;
    for(i=0;i<=2048;i++){
      if(rel_path[i]=='\0'){
        tail[tail_i]='\0';
        break;
      }
      if(found){
        tail[tail_i]=rel_path[i];
        tail_i++;
      }
      else{
        if(rel_path[i] == '.' || rel_path[i] == '/'){
          in_real[i]=rel_path[i];
        }
        else{
          tail[tail_i]=rel_path[i];
          tail_i++;
          found++;
          found_i=i;
        }
      }
    }
    in_real[found_i]='\0';
    if(in_real[found_i-1]=='/'){
      in_real[found_i-1]='\0';
    }
    
    char real_path[2048]="";
    realpath(in_real, real_path);
    safe_strcat(abs_path, real_path, 2048);
    safe_strcat(abs_path, "/", 2048);
    safe_strcat(abs_path, tail, 2048);
  }
  else{
    char real_path[2048]="";
    realpath(".", real_path);
    safe_strcat(abs_path, real_path, 2048);
    safe_strcat(abs_path, "/", 2048);
    safe_strcat(abs_path, rel_path, 2048);
  }
  
#ifdef __cplusplus
  string result(abs_path);
  return result;
#endif
}
