/*
* See the file LICENSE for redistribution information.
*
* Copyright: 2010- 1stclass.co.jp.  All rights reserved.
*
* Created by Hajime Kurita
*/
#include <sys/types.h>
#include <string.h>

#ifdef __cplusplus
#include "1stclass.hpp"
int firstclass::safe_strcat(char *dst, const char *src, size_t size){
#else
#include "1stclass.h"
int safe_strcat(char *dst, const char *src, size_t size){
#endif
  char *d = dst;
  const char *s = src;
  size_t n = size;
  size_t dlen;

  while (n-- != 0 && *d != '\0'){
    d++;
  }
  dlen = d - dst;
  n = size - dlen;

  if (n == 0){
    return 1;
  }

  while (*s != '\0') {
    if (n != 1) {
      *d++ = *s;
      n--;
    }
    s++;
  }
  *d = '\0';
  return 0;
}
