﻿//
//

#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <stdlib.h>
#include <malloc.h>
#include <memory.h>
#include <tchar.h>
#include <process.h>
#include <shlwapi.h>
#ifdef _MSC_VER
#pragma comment(lib, "shlwapi.lib")
#endif

#include "sample-winapp.h"
#include "../gettext.h"
#include "../get_lcid.h"

#define PACKAGE_NAME _T("hello-c")

#ifdef _DEBUG
#define _CRTDBG_MAP_ALLOC
#include <crtdbg.h>
#endif

#define MAX_LOADSTRING 100

// global variables
HINSTANCE hInst;								// My Instance
TCHAR szTitle[MAX_LOADSTRING];					// Text of title bar
TCHAR szWindowClass[MAX_LOADSTRING];			// main window class name

HWND hCtrls[12];
int iCtrlsCnt = 0;
int iCtrlFontName = 9;
int iCtrlFontSize = 9;
int iCtrlLang = 9;
int iCtrlBtnChange = 9;

HFONT hFont = NULL;
_TCHAR font_name[_MAX_PATH];
double font_size = 0.0;
char   lang_name[_MAX_PATH];
bool   lang_ok = false;

// prototype definition
ATOM				MyRegisterClass(HINSTANCE hInstance);
BOOL				InitInstance(HINSTANCE, int);
LRESULT CALLBACK	WndProc(HWND, UINT, WPARAM, LPARAM);
INT_PTR CALLBACK	About(HWND, UINT, WPARAM, LPARAM);

static bool set_locale(const char *locale);
static bool initialize_locale();

// main
int APIENTRY _tWinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPTSTR    lpCmdLine,
                     int       nCmdShow)
{
	UNREFERENCED_PARAMETER(hPrevInstance);
	UNREFERENCED_PARAMETER(lpCmdLine);

	MSG msg;
	HACCEL hAccelTable;

	// initialize global string
	LoadString(hInstance, IDS_APP_TITLE, szTitle, MAX_LOADSTRING);
	LoadString(hInstance, IDC_SAMPLEWINAPP, szWindowClass, MAX_LOADSTRING);
	MyRegisterClass(hInstance);

	// setting locale
	lang_ok = initialize_locale();

	// create window
	if (!InitInstance (hInstance, nCmdShow))
	{
		return 0;
	}

	hAccelTable = LoadAccelerators(hInstance, MAKEINTRESOURCE(IDC_SAMPLEWINAPP));

	// message loop
	while (GetMessage(&msg, NULL, 0, 0))
	{
		if (!TranslateAccelerator(msg.hwnd, hAccelTable, &msg))
		{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}

	// free all resources in libintl library
	libintl_tfreeres();

#ifdef _DEBUG
	_CrtDumpMemoryLeaks();
#endif

	return (int) msg.wParam;
}


//  Regist window class for my app
ATOM MyRegisterClass(HINSTANCE hInstance)
{
	WNDCLASSEX wcex;

	wcex.cbSize = sizeof(WNDCLASSEX);

	wcex.style			= CS_HREDRAW | CS_VREDRAW;
	wcex.lpfnWndProc	= WndProc;
	wcex.cbClsExtra		= 0;
	wcex.cbWndExtra		= 0;
	wcex.hInstance		= hInstance;
	wcex.hIcon			= LoadIcon(hInstance, MAKEINTRESOURCE(IDI_SAMPLEWINAPP));
	wcex.hCursor		= LoadCursor(NULL, IDC_ARROW);
	wcex.hbrBackground	= (HBRUSH)(COLOR_WINDOW+1);
	wcex.lpszMenuName	= MAKEINTRESOURCE(IDC_SAMPLEWINAPP);
	wcex.lpszClassName	= szWindowClass;
	wcex.hIconSm		= LoadIcon(wcex.hInstance, MAKEINTRESOURCE(IDI_SAMPLEWINAPP));

	return RegisterClassEx(&wcex);
}

//  Create window
BOOL InitInstance(HINSTANCE hInstance, int nCmdShow)
{
   HWND hWnd;

   hInst = hInstance;

   hWnd = CreateWindow(szWindowClass, szTitle, WS_OVERLAPPEDWINDOW,
      CW_USEDEFAULT, 0, 640, 200, NULL, NULL, hInstance, NULL);

   if (!hWnd)
   {
      return FALSE;
   }

   ShowWindow(hWnd, nCmdShow);
   UpdateWindow(hWnd);

   return TRUE;
}


/// set logical font
static void set_font(HWND hWnd, const _TCHAR *font_name, double point, LPLOGFONT plf)
{
	HDC hdc = GetDC(hWnd);

	int logdpiy = GetDeviceCaps(hdc, LOGPIXELSY);
	LONG nHeight = (LONG)(point * (double)logdpiy / 72);

	memset(plf, 0, sizeof(LOGFONT));
    plf->lfHeight = nHeight;
    plf->lfWidth = 0;
    plf->lfEscapement = 0;
    plf->lfOrientation = plf->lfEscapement;
    plf->lfWeight = FW_DONTCARE;
    plf->lfItalic = 0;
    plf-> lfUnderline = 0;
    plf->lfStrikeOut = 0;
    plf->lfCharSet = DEFAULT_CHARSET;
    plf->lfOutPrecision = OUT_DEFAULT_PRECIS;
    plf->lfClipPrecision = CLIP_DEFAULT_PRECIS;
    plf->lfQuality = DEFAULT_QUALITY;
    plf->lfPitchAndFamily = DEFAULT_PITCH | FF_DONTCARE;
	// フォント名
	_tcscpy(plf->lfFaceName, font_name);

	ReleaseDC(hWnd, hdc);
}

// translate messages on sub menu
// this function is recursive.
static void translate_submenu(HMENU hMenu)
{
	_TCHAR buf[_MAX_PATH];
	MENUITEMINFO mii;

	int nums = GetMenuItemCount(hMenu);
	for(int i=0; i<nums; i++) {
		memset(&mii, 0, sizeof(mii));
		mii.cbSize = sizeof(mii);
		mii.fMask = MIIM_SUBMENU | MIIM_STRING;
		mii.dwTypeData = buf;
		mii.cch = _MAX_PATH - 1;
		GetMenuItemInfo(hMenu, i, TRUE, &mii);
		if (mii.cch > 0) {
			mii.fMask = MIIM_STRING;
			const _TCHAR *p = _tgettext(mii.dwTypeData);
			if (p != buf) {
				memset(buf, 0, sizeof(buf));
				_tcsncpy(buf, p, _MAX_PATH-1);
			}
			mii.dwTypeData = buf;
			mii.cch = (UINT)_tcslen(buf);
			SetMenuItemInfo(hMenu, i, TRUE, &mii);
		}
		if (mii.hSubMenu != NULL) {
			translate_submenu(mii.hSubMenu);
		}
	}
}

// translate all messages on menu
static void translate_menu(HWND hWnd, HMENU hMenu)
{
	translate_submenu(hMenu);
}

// create window
static int create_window(HWND hWnd)
{
	// translate menu messages
	translate_menu(hWnd, GetMenu(hWnd));

	// create child controls
	_TCHAR msg[_MAX_PATH];

	_tcscpy(font_name, _T("MS UI Gothic"));
	font_size = 12.0;	

	// set logical font
	LOGFONT lf;
	set_font(hWnd, font_name, font_size, &lf);
	HFONT hNewFont = CreateFontIndirect(&lf);
	if (hNewFont != NULL) hFont = hNewFont;

	RECT re;

	DWORD dwStyle = 0;
	int w = lf.lfHeight;

	memset(hCtrls, 0, sizeof(hCtrls));

	// edit box
	re.left = 4;
	re.right = w * 30 + re.left;
	re.top = 4;
	re.bottom = lf.lfHeight + re.top + 4;
	dwStyle = ES_AUTOHSCROLL | ES_LEFT | WS_CHILD | WS_VISIBLE | WS_BORDER;
	hCtrls[iCtrlsCnt] = CreateWindow(_T("EDIT"), _T("")
	, dwStyle
	,re.left ,re.top, re.right-re.left, re.bottom-re.top, hWnd, NULL, hInst, NULL);
	if (hCtrls[iCtrlsCnt]) {
		// set text
		_stprintf(msg, _("This program is running as process number %d."), _getpid());
		SetWindowText(hCtrls[iCtrlsCnt], msg);
	}
	iCtrlsCnt++;

	// font name
	re.left = 4;
	re.right = w * 5 + re.left;
	re.top = re.bottom + 4;
	re.bottom = lf.lfHeight + re.top + 4;
	dwStyle = SS_CENTER | WS_CHILD | WS_VISIBLE;
	hCtrls[iCtrlsCnt] = CreateWindow(_T("STATIC"), _T("font name")
	, dwStyle
	,re.left ,re.top, re.right-re.left, re.bottom-re.top, hWnd, NULL, hInst, NULL);
	iCtrlsCnt++;

	re.left = re.right + 4;
	re.right = w * 10 + re.left;
	dwStyle = ES_AUTOHSCROLL | ES_LEFT | WS_CHILD | WS_VISIBLE | WS_BORDER;
	hCtrls[iCtrlsCnt] = CreateWindow(_T("EDIT"), font_name
	, dwStyle
	,re.left ,re.top, re.right-re.left, re.bottom-re.top, hWnd, NULL, hInst, NULL);
	iCtrlFontName = iCtrlsCnt;
	iCtrlsCnt++;

	// font size
	re.left = re.right + 4;
	re.right = w * 5 + re.left;
	dwStyle = SS_CENTER | WS_CHILD | WS_VISIBLE;
	hCtrls[iCtrlsCnt] = CreateWindow(_T("STATIC"), _T("font size")
	, dwStyle
	,re.left ,re.top, re.right-re.left, re.bottom-re.top, hWnd, NULL, hInst, NULL);
	iCtrlsCnt++;

	re.left = re.right + 4;
	re.right = w * 5 + re.left;
	dwStyle = ES_AUTOHSCROLL | ES_LEFT | WS_CHILD | WS_VISIBLE | WS_BORDER;
	hCtrls[iCtrlsCnt] = CreateWindow(_T("EDIT"), _T("")
	, dwStyle
	,re.left ,re.top, re.right-re.left, re.bottom-re.top, hWnd, NULL, hInst, NULL);
	iCtrlFontSize = iCtrlsCnt;
	if (hCtrls[iCtrlsCnt]) {
		// set text
		_stprintf(msg, _("%.1f"), font_size);
		SetWindowText(hCtrls[iCtrlsCnt], msg);
	}
	iCtrlsCnt++;

	// language
	re.left = 4;
	re.right = w * 5 + re.left;
	re.top = re.bottom + 4;
	re.bottom = lf.lfHeight + re.top + 4;
	dwStyle = SS_CENTER | WS_CHILD | WS_VISIBLE;
	hCtrls[iCtrlsCnt] = CreateWindow(_T("STATIC"), _T("language")
	, dwStyle
	,re.left ,re.top, re.right-re.left, re.bottom-re.top, hWnd, NULL, hInst, NULL);
	iCtrlsCnt++;

	re.left = re.right + 4;
	re.right = w * 15 + re.left;
	dwStyle = ES_AUTOHSCROLL | ES_LEFT | WS_CHILD | WS_VISIBLE | WS_BORDER;
	hCtrls[iCtrlsCnt] = CreateWindow(_T("EDIT"), _T("")
	, dwStyle
	,re.left ,re.top, re.right-re.left, re.bottom-re.top, hWnd, NULL, hInst, NULL);
	iCtrlLang = iCtrlsCnt;
	if (hCtrls[iCtrlsCnt]) {
		// set text
		SetWindowTextA(hCtrls[iCtrlsCnt], lang_name);
	}
	iCtrlsCnt++;

	re.left = re.right + 4;
	re.right = w * 3 + re.left;
	dwStyle = SS_CENTER | WS_CHILD | WS_VISIBLE;
	hCtrls[iCtrlsCnt] = CreateWindow(_T("STATIC"), lang_ok ? _T("OK") : _T("NG") 
	, dwStyle
	,re.left ,re.top, re.right-re.left, re.bottom-re.top, hWnd, NULL, hInst, NULL);
	iCtrlsCnt++;

	// button
	re.left = re.right + 4;
	re.right = w * 5 + re.left;
	dwStyle = BS_DEFPUSHBUTTON | BS_TEXT | BS_CENTER | WS_CHILD | WS_VISIBLE;
	hCtrls[iCtrlsCnt] = CreateWindow(_T("BUTTON"), _T("change")
	, dwStyle
	,re.left ,re.top, re.right-re.left, re.bottom-re.top, hWnd, NULL, hInst, NULL);
	iCtrlBtnChange = iCtrlsCnt;
	iCtrlsCnt++;

	hCtrls[iCtrlsCnt] = NULL;

	for(int i=0; i<iCtrlsCnt; i++) {
		// set font
		if (hFont != NULL) SendMessage(hCtrls[i], WM_SETFONT, (WPARAM)hFont, MAKELPARAM(TRUE, 0));
	}

	return 0;
}

// change controls in window
static int update_window(HWND hWnd)
{
	_TCHAR msg[_MAX_PATH];

	// set languate
	char new_locale[_MAX_PATH];
	GetWindowTextA(hCtrls[iCtrlLang], new_locale, _MAX_PATH-1);
	lang_ok = set_locale(new_locale);

	//
	// Menu messages on window are already translated. So you need reattach original messages and translate them again.
	//
	// load menu from resource
	HMENU hNewMenu = LoadMenu(hInst, MAKEINTRESOURCE(IDC_SAMPLEWINAPP));
	// destroy current menu on window
	DestroyMenu(GetMenu(hWnd));
	// reattach menu to window
	SetMenu(hWnd, hNewMenu);
	// translate menu messages
	translate_menu(hWnd, GetMenu(hWnd));

	// get font name and size from window
	GetWindowText(hCtrls[iCtrlFontName], font_name, _MAX_PATH-1);
	GetWindowText(hCtrls[iCtrlFontSize], msg, _MAX_PATH-1);
	_TCHAR *endp;
	font_size = _tcstod(msg, &endp);
	if (font_size < 6.0) font_size = 6.0;
	if (font_size > 48.0) font_size = 48.0;

	// set logical font
	LOGFONT lf;
	set_font(hWnd, font_name, font_size, &lf);
	HFONT hFont = CreateFontIndirect(&lf);

	RECT re;

	int cnt = 0;
	int w = lf.lfHeight;

	// edit box
	re.left = 4;
	re.right = w * 30 + re.left;
	re.top = 4;
	re.bottom = lf.lfHeight + re.top + 4;
	if (hCtrls[cnt]) {
		SetWindowPos(hCtrls[cnt], NULL, re.left, re.top, re.right - re.left, re.bottom - re.top, 0);

		// set text
		_stprintf(msg, _("This program is running as process number %d."), _getpid());
		SetWindowText(hCtrls[cnt], msg);
	}
	cnt++;

	// font name
	re.left = 4;
	re.right = w * 5 + re.left;
	re.top = re.bottom + 4;
	re.bottom = lf.lfHeight + re.top + 4;
	if (hCtrls[cnt]) {
		SetWindowPos(hCtrls[cnt], NULL, re.left, re.top, re.right - re.left, re.bottom - re.top, 0);
	}
	cnt++;

	re.left = re.right + 4;
	re.right = w * 10 + re.left;
	if (hCtrls[cnt]) {
		SetWindowPos(hCtrls[cnt], NULL, re.left, re.top, re.right - re.left, re.bottom - re.top, 0);

		// set text
		SetWindowText(hCtrls[iCtrlsCnt], font_name);
	}
	cnt++;

	// font size
	re.left = re.right + 4;
	re.right = w * 5 + re.left;
	if (hCtrls[cnt]) {
		SetWindowPos(hCtrls[cnt], NULL, re.left, re.top, re.right - re.left, re.bottom - re.top, 0);
	}
	cnt++;

	re.left = re.right + 4;
	re.right = w * 5 + re.left;
	if (hCtrls[cnt]) {
		SetWindowPos(hCtrls[cnt], NULL, re.left, re.top, re.right - re.left, re.bottom - re.top, 0);

		// set text
		_TCHAR msg[100];
		_stprintf(msg, _("%.1f"), font_size);

		SetWindowText(hCtrls[iCtrlsCnt], msg);
	}
	cnt++;

	// lang
	re.left = 4;
	re.right = w * 5 + re.left;
	re.top = re.bottom + 4;
	re.bottom = lf.lfHeight + re.top + 4;
	if (hCtrls[cnt]) {
		SetWindowPos(hCtrls[cnt], NULL, re.left, re.top, re.right - re.left, re.bottom - re.top, 0);
	}
	cnt++;

	re.left = re.right + 4;
	re.right = w * 15 + re.left;
	if (hCtrls[cnt]) {
		SetWindowPos(hCtrls[cnt], NULL, re.left, re.top, re.right - re.left, re.bottom - re.top, 0);

		// set text
		SetWindowTextA(hCtrls[cnt], lang_name);
	}
	cnt++;

	re.left = re.right + 4;
	re.right = w * 3 + re.left;
	if (hCtrls[cnt]) {
		SetWindowPos(hCtrls[cnt], NULL, re.left, re.top, re.right - re.left, re.bottom - re.top, 0);

		SetWindowText(hCtrls[cnt], lang_ok ? _T("OK") : _T("NG"));
	}
	cnt++;

	// button
	re.left = re.right + 4;
	re.right = w * 5 + re.left;
	if (hCtrls[cnt]) {
		SetWindowPos(hCtrls[cnt], NULL, re.left, re.top, re.right - re.left, re.bottom - re.top, 0);
	}
	cnt++;

	for(int i=0; i<iCtrlsCnt; i++) {
		// set font
		if (hFont != NULL) SendMessage(hCtrls[i], WM_SETFONT, (WPARAM)hFont, MAKELPARAM(TRUE, 0));
	}

	return 0;
}

//  Process messages
LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	int wmId, wmEvent;
	PAINTSTRUCT ps;
	HDC hdc;

	switch (message)
	{
	case WM_COMMAND:
		wmId    = LOWORD(wParam);
		wmEvent = HIWORD(wParam);
		// selected menu item
		switch (wmId)
		{
		case IDM_ABOUT:
			DialogBox(hInst, MAKEINTRESOURCE(IDD_ABOUTBOX), hWnd, About);
			break;
		case IDM_EXIT:
			DestroyWindow(hWnd);
			break;
		default:
			if ((HWND)lParam == hCtrls[iCtrlBtnChange]) {
				// change button
				update_window(hWnd);
			} else {
				return DefWindowProc(hWnd, message, wParam, lParam);
			}
		}
		break;
	case WM_CREATE:
		create_window(hWnd);
		break;
	case WM_PAINT:
		hdc = BeginPaint(hWnd, &ps);
		EndPaint(hWnd, &ps);
		break;
	case WM_DESTROY:
		PostQuitMessage(0);
		break;
	default:
		return DefWindowProc(hWnd, message, wParam, lParam);
	}
	return 0;
}

// translate messages on about box
static BOOL CALLBACK enum_about_box_proc(HWND hWnd, LPARAM lParam)
{
	_TCHAR class_name[_MAX_PATH];
	GetClassName(hWnd, class_name, _MAX_PATH-1);
	if (_tcscmp(class_name, _T("Static")) == 0) {
		// translate text on static control
		_TCHAR str[_MAX_PATH];
		memset(str, 0, sizeof(str));
		GetWindowText(hWnd, str, _MAX_PATH-1);
		SetWindowText(hWnd, _tgettext(str));
	}
	return TRUE;
}

// create about box
static INT_PTR create_about_box(HWND hDlg)
{
	_TCHAR str[_MAX_PATH];
	memset(str, 0, sizeof(str));

	// translate title bar
	GetWindowText(hDlg, str, _MAX_PATH-1);
	SetWindowText(hDlg, _tgettext(str));

	// translate messages on child controls
	EnumChildWindows(hDlg, enum_about_box_proc, NULL);

	return (INT_PTR)TRUE;
}

// about dialog box
INT_PTR CALLBACK About(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	UNREFERENCED_PARAMETER(lParam);
	switch (message)
	{
	case WM_INITDIALOG:
		return create_about_box(hDlg);

	case WM_COMMAND:
		if (LOWORD(wParam) == IDOK || LOWORD(wParam) == IDCANCEL)
		{
			EndDialog(hDlg, LOWORD(wParam));
			return (INT_PTR)TRUE;
		}
		break;
	}
	return (INT_PTR)FALSE;
}

// set locale
static bool set_locale(const char *locale)
{
	memset(lang_name, 0, sizeof(lang_name));

	const char *new_locale = setlocale(LC_ALL, locale);
	if (new_locale == NULL) {
		return false;
	}
	LCID lcid = get_lcid(new_locale);
	if (SetThreadLocale(lcid) != TRUE) {
		return false;
	}

	strncpy(lang_name, new_locale, _MAX_PATH-1);

	return true;
}

// initialize locale
static bool initialize_locale()
{
	if (!set_locale("")) {
		return false;
	}

	TCHAR locale_dir[3000];
	DWORD result = GetModuleFileName(GetModuleHandle(NULL), 
									locale_dir, sizeof(locale_dir)/sizeof(TCHAR) - 1);

	if (result == 0 || result > 2950) {
		return false;
	}

	if (PathRemoveFileSpec(&locale_dir[0]) == FALSE) {
		return false;
	}
	TCHAR *p = _tcsstr(locale_dir, _T("sample-"));
	if (p != NULL) {
		*p = 0;
	}

	const TCHAR dir[] = _T("locale");
	if (PathAppend(&locale_dir[0], dir) == FALSE) {
		return false;
	}

	if (_tbindtextdomain(PACKAGE_NAME, locale_dir) == NULL) {
		return false;
	}
#if defined(UNICODE) || defined(_UNICODE)
	if (wbind_textdomain_codeset(PACKAGE_NAME, _T("UTF-16LE")) == NULL) {
		return false;
	}
#endif
	if (_ttextdomain(PACKAGE_NAME) == NULL) {
		return false;
	}

	return true;
}
