/**
 * html[0.9.0]
 * (c) 2007 Shigehito funaki <funaki@sourceforge.jp>
 */
//LogConfig.add({category: 'com.html', level: LOG_LEVEL.DEBUG});

var Html = {
	logger : LoggerFactory.create("com.html"),
	create : function(param) {
		Html.logger.debug("Html#create");
		Html.logger.debug("param:" + param);

		var obj = document.createElement(param.tag);
		obj.setAttribute('id',		param.id);
		obj.setAttribute('name',	param.name);
		if (param.text) {
			var txt = document.createTextNode(param.text);	
			obj.appendChild(txt);
		}
		for (var attb in param.attribute) {
			var val = param.attribute[attb];
			obj.setAttribute(attb, val);

			Html.logger.debug("setAttribute " + attb + "=" + val);
		}
		Element.setStyle(obj, param.style);
//		Html.logger.debug("setStyle " + param.style);
		Html.logger.debug(obj);
	
		if (param.children) {
			var c = param.children;
			for (var i = 0; i < c.length; i++) {
				obj.appendChild(Html.create(c[i]));
			}
		}
		return obj;
	},
	override : function(destination, source) {
		if (!destination) return destination;
		for (property in source) {
			if (source[property]) {
				destination[property] = source[property];
			}
		}
		return destination;
	}
};

/** スタイルデフォルト値 */
Html.Default = {
	dataTableBorder : {
		borderStyle		: "solid",
		borderWidth		: "1px",
		borderColor		: "#666666"	,
		borderCollapse	: "collapse"
	}
};


/** HTML生成用データのスーパークラス */
Html.Data = function() {
	this.tag		= null;			//タグ名
	this.id			= null;			//htmlのid属性
	this.name		= null;			//htmlのname属性
	this.text		= null;			//内部のテキストノード
	this.attribute	= {};			//一般的属性。要素はタグにより異なる
	this.style		= {};			//スタイル属性
	this.children	= new Array();	//内包タグのデータ
};

/** レイアウト用テーブルデータ */
Html.Data.LayoutTable = function() {
	Html.override(this, Html.Data);
	this.tag		= 'table';
	this.children	= new Array(
		{
			tag       : 'tbody',
			children  : new Array()
		}
	);
	this.tbody		= this.children[0].children;
	this.addRecord	= function(tr) {
//		var tbody = this.children[0].children;
		this.tbody[this.tbody.length] = tr;
	};
};

/** データ表示用テーブルのデータ */
Html.Data.DataTable = function() {
	Html.override(this, new Html.Data.LayoutTable());
	this.style		= Html.Default.dataTableBorder;
	this.addRecord	= function(tr) {
		var tbody = this.children[0].children;
		Html.override(tr.style, Html.Default.dataTableBorder);
		for (var i = 0; i < tr.children.length; i++) {
			Html.override(tr.children[i].style, Html.Default.dataTableBorder);
		}
		tbody[tbody.length] =　tr;
	};
};

/** select生成用データ */
Html.Data.Select = function(name) {
	Html.override(this, new Html.Data());
	this.tag		= 'select';
	this.name		= name;
	this.setItem	= function(items) {
		var ary = this.children;
		for (var item in items) {
			var opt = new Html.Data.Option(item, items[item]);
			ary[ary.length] = opt;
		}
	}
};

/** radio生成用データ */
Html.Data.Radio = function(name, val, txt) {
	Html.override(this, new Html.Data());
	var id = name + "_" + val;
	this.tag		= 'div';
	this.children	= new Array(
		{
			tag       : 'input',
			id        : id,
			name      : name,
			attribute : {type: 'radio', value: val}
		},
		{
			tag       : 'label',
			text      : txt,
			attribute : {'for' : id}
		}
	);
};

/** option生成用データ */
Html.Data.Option = function(val, txt) {
	Html.override(this, new Html.Data());
	this.tag		= 'option';
	this.text		= txt;
	this.attribute	= {value: val};
};

/** tr生成用データ */
Html.Data.Tr = function(options) {
	Html.override(this, new Html.Data());
	Html.override(this, options);
	this.tag		= 'tr';
};

/** th生成用データ */
Html.Data.Th = function(options) {
	Html.override(this, new Html.Data());
	Html.override(this, options);
	this.tag		= 'th';
};

/** td生成用データ */
Html.Data.Td = function(options) {
	Html.override(this, new Html.Data());
	Html.override(this, options);
	this.tag		= 'td';
};

/** div生成用データ */
Html.Data.Div = function(id, options) {
	Html.override(this, new Html.Data());
	Html.override(this, options);
	this.tag		= 'div';
	this.id			= id;
};

/** image生成用データ */
Html.Data.Image = function(id, src, title, style) {
	Html.override(this, new Html.Data());
	this.attribute	= {src: src, title: title};
	this.style		= style;
	this.tag		= 'img';
	this.id			= id;
};

/** anchor生成用データ */
Html.Data.Anchor = function(id, href, title, style) {
	Html.override(this, new Html.Data());
	this.attribute	= {href: href, title: title};
	this.style		= style;
	this.tag		= 'a';
	this.id			= id;
};

