/**
 * imageView[0.9.1]
 * (c) 2007 Shigehito funaki <funaki@sourceforge.jp>
 */
//LogConfig.add({category: 'com.gui.imageView', level: LOG_LEVEL.DEBUG});

WUI.ImageView = new Object();
WUI.ImageView.logger = LoggerFactory.create("com.gui.imageView");

//------------------------------------------------------------------------------
// イメージビューのユーザーモデル。これをnewしてください。
WUI.ImageView.Area = Class.create();
WUI.ImageView.Area.prototype = {
  initialize: function(divObj, id, viewParam, imgParam, toolParam, option) {
    WUI.ImageView.logger.debug("WUI.ImageView.Area#initialize");

    this.divObj  = null;
    this.imgObj  = null;
    this.toolObj = null;

    // イベントハンドラ用変数
    this.eventVars = {
      mode        : "",
      dragging    : false,
      press       : false,
      lastPointerX: 0,  //前回mouseDown位置x(ドキュメント内)
      lastPointerY: 0,  //前回mouseDown位置y(ドキュメント内)
      lastLayerX  : 0,  //前回mouseDown位置x(オブジェクト内)
      lastLayerY  : 0,  //前回mouseDown位置y(オブジェクト内)
      imgX        : 0,  //クリック時画像位置x
      imgY        : 0,  //クリック時画像位置y
      width       : 0,  //
      height      : 0   //
    };

    this.state = {
      tool   : null,
      ratio  : 0.002,
      x      : 0,
      y      : 0
    };

    this.parent    = divObj;
    this.id        = id;
    this.viewParam = Object.extend({
            width : 400,
            height: 400
        }, viewParam);
    this.imgParam  = imgParam;
    this.toolParam = Object.extend({
            zoomIn      : true,
            zoomOut     : true,
            zoomRect    : true,
            zoomAll     : true,
            ratioZoomIn : 1.51,
            ratioZoomOut: 0.66,
            stepMove    : 6,
            stepZoomIn  : 6,
            stepZoomOut : 6,
            stepZoomRect: 10,
            stepZoomAll : 10
        }, toolParam);
    this.option    = Object.extend({
            imgdir: '../img',
            ratio_max: 2.0,
            ratio_min: 0.01
        }, option);

    //for animation
    this.animation = new Object();
    this.animation.cue  = new WUI.Cue();
    new PeriodicalExecuter(this._timerCallback.bind(this), 0.005);

    //check parameters
    if (!imgParam.width) {
      WUI.ImageView.logger.warn("imgParam.widthが設定されていません。");
      return;
    }
    if (!imgParam.height) {
      WUI.ImageView.logger.warn("imgParam.heightが設定されていません。");
      return;
    }

    this.setViewSize(viewParam.width, viewParam.height);
    this._createElement(this.viewParam, this.imgParam);
    this._setEventHandler();
    this.usertool = new WUI.ImageView.UserTools(this);
    this.show();
  },

  setViewSize: function(width, height) {
    if (width  < 32) width  = 32;
    if (height < 32) height = 32;
    this.viewParam.width  = width;
    this.viewParam.height = height;

    var rx = width  / this.imgParam.width;
    var ry = height / this.imgParam.height;
    this.option.ratio_min = (rx < ry) ? rx : ry;
  },

  moveTo: function(x, y, count) {
    WUI.ImageView.logger.debug("moveTo x:" + x + " y:" + y);
    if (isNaN(x)) {
      x = this.state.x;
    }
    if (isNaN(y)) {
      y = this.state.y;
    }  
  
    var src = new WUI.ImageView.Angle(this.state);
    var dst = new WUI.ImageView.Angle();
    dst.x     = x;
    dst.y     = y;
    dst.ratio = this.state.ratio;
    this._animate(src, dst, count);
  },

  moveCenter: function(count) {
    this.moveTo(0, 0, count);
  },

  zoomTo: function(ratio, count) {
    WUI.ImageView.logger.debug("zoomTo ratio:" + ratio);
    if (ratio <= this.option.ratio_min) {
      this.zoomAll();
      return;
    }
    if (ratio > this.option.ratio_max) ratio = this.option.ratio_max;
    
    var src = new WUI.ImageView.Angle(this.state);
    var dst = new WUI.ImageView.Angle();
    dst.x     = this.state.x;
    dst.y     = this.state.y;
    dst.ratio = ratio;
    this._animate(src, dst, count);
  },

  zoom: function(ratio, count) {
    this.zoomTo(this.state.ratio * ratio, count);
  },
  
  zoomRect: function(param, count) {
    var rx = this.viewParam.width  / param.width;
    var ry = this.viewParam.height / param.height;
    var r  = (rx < ry) ? rx : ry;
    var x = param.x;
    var y = param.y;

    var src = new WUI.ImageView.Angle(this.state);
    var dst = new WUI.ImageView.Angle();
    dst.x     = x;
    dst.y     = y;
    dst.ratio = r;
    this._animate(src, dst, count);
  },

  zoomAll: function(count) {
    var w = this.imgParam.width;
    var h = this.imgParam.height;

    var ret = new Object();
    ret.left   = 0;
    ret.top    = 0;
    ret.right  = w;
    ret.bottom = h;
    ret.x      = 0;
    ret.y      = 0;
    ret.width  = w;
    ret.height = h;
    
    this.zoomRect(ret, count);
  },
  
  setByPixel: function(x, y) {
    this.state.x = this._pixelToMapX(x);
    this.state.y = this._pixelToMapY(y);
  },

  _animate: function(src, dist, count) {
    WUI.ImageView.logger.debug("_animate src[" + src.inspect() + "]dst[" + dist.inspect() + "]");
    this.fit(dist);

    var count = (count >= 0) ? count : 4;
    var cue   = this.animation.cue;
    for (var i = 0; i <= count; i++) {
      var st = new WUI.ImageView.Angle();
      
      if (i == count) {
        st.ratio  = src.ratio + (dist.ratio - src.ratio);
        st.x      = src.x + (dist.x - src.x);
        st.y      = src.y + (dist.y - src.y);
      } else {
        var s = (i / count);
        st.ratio  = src.ratio + (dist.ratio - src.ratio) * s;
        st.x      = src.x + (dist.x - src.x) * s;
        st.y      = src.y + (dist.y - src.y) * s;
      }
      //最大拡大率を超えた場合、最大を設定して以降をキャンセル
      if (st.ratio > this.option.ratio_max) {
          st.ratio = this.option.ratio_max;
          i = count;
      }

      cue.addTail(new WUI.Cue(st));
      cue = cue.next;
    }
  },
  
  _timerCallback: function() {   
    var cue = this.animation.cue;
    var st = cue.obj;
    if (!st) {
      if (cue.next) {
        this.animation.cue = cue.removeHead();
        this._timerCallback();
      }
      return;
    }
    
    var r = st.ratio;
    WUI.Util.setRect(this.divObj,
        this._mapToPixelX(st.x, r), this._mapToPixelY(st.y, r),
        this.imgParam.width * r,    this.imgParam.height * r);

    this.state.x     = st.x;
    this.state.y     = st.y;
    this.state.ratio = st.ratio;

    if (cue.next) {
      this.animation.cue = cue.removeHead();
    } else {
      this.animation.cue = new WUI.Cue();
      this.usertool.setBottonImage(null, false);//全てのボタンをOFF
    }
  },



  show: function() {
    this.zoomAll(0);
  },

  setTool: function(toolName, callbackFunction) {
    var oldTool = this.state.tool;
    var newTool = this._createTool(toolName);
    if (oldTool && newTool && oldTool.getId() == newTool.getId()) {
      this.state.tool.restart(this);
      return;
    } else {
      if (oldTool) {
        oldTool.end(this);
      }    
      if (newTool) {
        newTool.start(this);
      }
    }
    
    if (callbackFunction) {
      newTool.callback = callbackFunction;
    }
    
    this.state.tool = newTool;
  },
  
  _createTool: function(toolName) {
    if (toolName == "move") return new WUI.ImageView.Tools.Move(this);
    if (toolName == "rect") return new WUI.ImageView.Tools.Rect(this);
    if (toolName == "zoom") return new WUI.ImageView.Tools.LocalRectZoom(this);
  },



  _mouseDown: function(e) {
    var vars = this.eventVars;
    var tool = this.state.tool;
    if (!tool) return;

    vars.lastPointerX = Event.pointerX(e);
    vars.lastPointerY = Event.pointerY(e);
    vars.lastLayerX   = WUI.Event.layerX(e, this.divObj.id);
    vars.lastLayerY   = WUI.Event.layerY(e, this.divObj.id);
    vars.press        = true;
    vars.dragging     = tool.down(e, vars, this);
  },

  _mouseMove: function(e) {
    var vars = this.eventVars;
    var tool = this.state.tool;
    if (!tool) return;

    if (vars.dragging) {
      tool.drag(e, vars, this);
    } else {
      tool.move(e, vars, this);
    }
  },

  _mouseUp: function(e) {
    var vars = this.eventVars;
    var tool = this.state.tool;
    if (tool) {
      tool.up(e, vars, this);

      var x = Event.pointerX(e);
      var y = Event.pointerY(e);
      if (vars.press && (vars.lastPointerX - x) == 0 && (vars.lastPointerY - y) == 0) {
        tool.click(e, vars, this);
        vars.press = false;
      }
    }
    vars.dragging = false;
  },
  
  _mouseOut: function(e) {
    var vars = this.eventVars;
    var tool = this.state.tool;
    if (tool) {
      tool.out(e, vars, this);
    }
    vars.dragging = false;
  },

  

  _createElement: function(viewParam, imgParam) {
    var divId = this.id + "_div";
    var imgId = this.id + "_img";
    
    //親
    WUI.Util.setSize(this.parent, viewParam.width, viewParam.height);
    Element.setStyle(this.parent, {overflow: 'hidden',position: 'relative'});

    //imgを入れるdiv
    var options = {
      style : {
        backgroundColor: '#dddddd',
        top     : '1000px',
        left    : '1000px',
        width   : '0px',
        height  : '0px',
        position: 'relative' /* relative absolute */
      }
    };
    var div = new Html.Data.Div(divId, options);
    this.divObj = Html.create(div);
    
    //img
    var img = {
      tag		: 'img',
      id		: imgId,
      attribute	: {
        src       : imgParam.src
      },
      style		: {
        border    : '0px',
        left      : '0px',
        top       : '0px',
        width     : '100%',
        height    : '100%'
      }
    };
    this.imgObj = Html.create(img);

    //内包させる
    this.divObj.appendChild(this.imgObj);
    this.parent.appendChild(this.divObj);
  },
  
  _setEventHandler: function() {
    Event.observe(this.divObj, 'mousedown', this._mouseDown.bind(this), true);
    Event.observe(this.divObj, 'mousemove', this._mouseMove.bind(this), true);
    Event.observe(this.parent, 'mouseup',   this._mouseUp.bind(this),   true);
    Event.observe(this.parent, 'mouseout',  this._mouseOut.bind(this),  true);
  },
  
  
  
  fit: function(st) {
    var r = st.ratio;
    var w = this.imgParam.width * r;
    var h = this.imgParam.height * r;
    var vw = this.viewParam.width;
    var vh = this.viewParam.height;
    var iw = (w <= vw);
    var ih = (h <= vh);
    var cx, cy;
    if (iw && ih) {
      cx = true;
      cy = true;
    } else if (iw) {
      cx = true;
      cy = false;
    } else if (ih) {
      cx = false;
      cy = true;
    } else {
      cx = false;
      cy = false;
    }    
    
    var vminx = (vw - 0) / 2 / r * -1;
    var vmaxx = (vw - 0) / 2 / r;
    var vminy = (vh - 0) / 2 / r * -1;
    var vmaxy = (vh - 0) / 2 / r;
    var w2 = w / r / 2;
    var h2 = h / r / 2;
    var minx = (st.x) - w2;
    var maxx = (st.x) + w2;
    var miny = (st.y) - h2;
    var maxy = (st.y) + h2;

    if (cx) {
      if (minx < vminx) st.x = vminx + w2;
      if (maxx > vmaxx) st.x = vmaxx - w2;
    } else {
      if (maxx <= vmaxx) st.x = vmaxx - w2;
      if (minx >= vminx) st.x = vminx + w2;
    }
    if (cy) {
      if (miny < vminy) st.y = vminy + h2;
      if (maxy > vmaxy) st.y = vmaxy - h2;
    } else {
      if (maxy <= vmaxy) st.y = vmaxy - h2;
      if (miny >= vminy) st.y = vminy + h2;
    }
    return st;
  },
  
  /**
   * 論理座標Xをレイヤー座標へ変換する。
   * @param x  論理座標X
   * @param r  拡大率
   */
  _mapToPixelX: function(x, r) {
    if (!r) r = this.state.ratio;
    return x * r + this.viewParam.width  / 2 - this.imgParam.width  * r / 2;
  },
  _mapToPixelY: function(y, r) {
    if (!r) r = this.state.ratio;
    return y * r + this.viewParam.height / 2 - this.imgParam.height * r / 2;
  },

  _pixelToMapX: function(x, r) {
    if (!r) r = this.state.ratio;
    return x / r - this.viewParam.width  / (2 * r) + this.imgParam.width  / 2;
  },
  _pixelToMapY: function(y, r) {
    if (!r) r = this.state.ratio;
    return y / r - this.viewParam.height / (2 * r) + this.imgParam.height / 2;
  }
};

WUI.ImageView.Angle = Class.create();
Object.extend(WUI.ImageView.Angle.prototype, {
  initialize: function(src) {
    this.x     = 0;
    this.y     = 0;
    this.ratio = 0;
    if (src) {
      this.x     = src.x;
      this.y     = src.y;
      this.ratio = src.ratio;
    }
  },
  clone: function() {
    return new WUI.ImageView.Angle(this);
  },
  inspect: function() {
    return "x:" + this.x + " y:" + this.y + " r:" + this.ratio;
  }
});

//------------------------------------------------------------------------------
//ツールホルダ
WUI.ImageView.Tools = new Object();

//------------------------------------------------------------------------------
// ツールの空実装
WUI.ImageView.Tools.Template = Class.create();
WUI.ImageView.Tools.Template.prototype = {
  initialize: function(view) {
    if (view) {	//クラス生成時、引数なしのケースあり
      this.view      = view;
      this.eventVars = view.eventVars;
    }
    this.removed = false;
  },
  getId     : function()  {return 'Template';},
  click     : function(e) {return false},
  down      : function(e) {return false},
  move      : function(e) {return false},
  drag      : function(e) {return false},
  up        : function(e) {return false},
  out       : function(e) {return false},
  start     : function() {},
  end       : function() {},
  restart   : function() {this.end();this.start();},
  callback  : function() {}
};

//------------------------------------------------------------------------------
// 移動ツール
WUI.ImageView.Tools.Move = Class.create();
WUI.ImageView.Tools.Move.prototype = Object.extend(new WUI.ImageView.Tools.Template(), {
  getId     : function()  {return 'Move';},
  start: function() {
    Element.setStyle(this.view.imgObj, {cursor: 'move'});
  },

  end: function() {
    Element.setStyle(this.view.imgObj, {cursor: ''});
  },

  click: function(e) {
    WUI.ImageView.logger.debug("move tool clicked");

    var v = this.view;
    var obj = v.divObj;

    var lx = WUI.Event.layerX(e, v.divObj.id);
    var ly = WUI.Event.layerY(e, v.divObj.id);
    var cx = v.imgParam.width  / 2;
    var cy = v.imgParam.height / 2;
    var r  = v.state.ratio;
    var x  = cx - lx / r;
    var y  = cy - ly / r;
    WUI.ImageView.logger.debug("x:" + x + " y:" + y);

    v.moveTo(x, y, v.toolParam.stepMove);
  },
  
  down: function(e) {
    WUI.ImageView.logger.debug("move tool down");

    this.eventVars.imgX = WUI.Util.getElementX(this.view.divObj);
    this.eventVars.imgY = WUI.Util.getElementY(this.view.divObj);
  
    Event.stop(e);
    return true;
  },
   
  drag: function(e) {
    var ev = this.eventVars;
    var v  = this.view;

    var x = Event.pointerX(e) - ev.lastPointerX + new Number(ev.imgX);
    var y = Event.pointerY(e) - ev.lastPointerY + new Number(ev.imgY);
    x = v._pixelToMapX(x);
    y = v._pixelToMapY(y);
    var r  = v.state.ratio;
    var st = v.fit({x: x, y: y, ratio: r});
    v.state.x = st.x;
    v.state.y = st.y;
    WUI.Util.setRect(v.divObj,
        v._mapToPixelX(st.x, r),
        v._mapToPixelY(st.y, r),
        v.imgParam.width * r,
        v.imgParam.height * r);

    Event.stop(e);
  },
      
  up: function(e, vars) {
    var v = this.view;
    this.callback.call(v, v.state);
  }
});

//------------------------------------------------------------------------------
// 矩形選択
WUI.ImageView.Tools.Rect = Class.create();
WUI.ImageView.Tools.Rect.prototype = Object.extend(new WUI.ImageView.Tools.Template(), {
  getId     : function()  {return 'Rect';},
  start: function() {
    var v = this.view;
    Element.setStyle(this.view.imgObj, {cursor: 'crosshair'});
    this.view.toolObj = "";
    this.parent = this.view.divObj;

    this.running = false;
  },

  end: function() {
    Element.setStyle(this.view.imgObj, {cursor: ''});
    this.removeToolObj(this.view);
    this.running = false;
  },

  click: function(e) {
    var v  = this.view;
    var ev = this.eventVars;

    var obj = v.toolObj;
    if (obj) {
      //２回目のクリック
      this.running = false;

      var x = WUI.Util.getElementX(obj);
      var y = WUI.Util.getElementY(obj);
      var w = WUI.Util.getElementWidth( obj);
      var h = WUI.Util.getElementHeight(obj);
      var cx = v.imgParam.width  / 2;
      var cy = v.imgParam.height / 2;
      var r  = v.state.ratio;

      var ret = new Object();
      ret.left   = cx - (x + w) / r;
      ret.top    = cy - (y + h) / r;
      ret.right  = cx - x / r;
      ret.bottom = cy - y / r;
      ret.x      = cx - (x + w / 2) / r;
      ret.y      = cy - (y + h / 2) / r;
      ret.width  = w / r;
      ret.height = h / r;
WUI.ImageView.logger.debug(ret);
      this.callback.call(v, ret);
      this.removeToolObj(v);

    } else {
      //１回目のクリック
      var x = WUI.Event.layerX(e, v.divObj.id);
      var y = WUI.Event.layerY(e, v.divObj.id);
      
      WUI.ImageView.logger.debug("[rect]first point clicked. x=" + x + " y=" + y);
      this.createToolObj(v, x, y);
      this.running = true;
    }
  },
   
  move: function(e) {
    var obj = this.view.toolObj;
    if (!obj || !this.running) return;

    var x2 = WUI.Event.layerX(e, this.view.divObj.id);
    var y2 = WUI.Event.layerY(e, this.view.divObj.id);
    if (Event.element(e) != this.view.imgObj) {
      x2 = this.eventVars.lastLayerX + Event.pointerX(e) - this.eventVars.lastPointerX;
      y2 = this.eventVars.lastLayerY + Event.pointerY(e) - this.eventVars.lastPointerY;
    }
    var x  = this.eventVars.lastLayerX;
    var y  = this.eventVars.lastLayerY;
    var w = x2 - x;
    var h = y2 - y;

    if (w < 0) {
      w = w * -1;
      x = x - w;
    }
    if (h < 0) {
      h = h * -1;
      y = y - h;
    }

    WUI.Util.setPosition(obj, x, y);
    WUI.Util.setSize(obj, w, h);
  },
  
  createToolObj : function(view, x, y) {
    var options = {
      cursor   : 'crosshair',
      overflow : 'hidden',
      position : 'absolute', /* relative absolute */
      border   : '1px solid #FF0000',

      backgroundColor: "#ffcccc",
      filter   : 'alpha(opacity=50)',
      opacity  : '0.5',

      left     : x + 'px',
      top      : y + 'px',
      width    : '1px',
      height   : '1px'
    };

    var obj = document.createElement('div');

    view.toolObj = obj;
    Element.setStyle(obj, options);
    if (this.parent) {
      this.parent.appendChild(obj);
    }
  },
  
  removeToolObj : function(view) {
    var obj = view.toolObj;
    if (!obj) return;
 
    if (this.parent) {
      this.parent.removeChild(obj);
    }
    view.toolObj = null;
  },
  
  restart: function() {
    this.end();
    this.view.usertool.setBottonImage('zoom_rect', false);//全てのボタンをOFF
    this.view.setTool('move');
  }
});

//------------------------------------------------------------------------------
// 矩形ズーム
WUI.ImageView.Tools.LocalRectZoom = Class.create();
WUI.ImageView.Tools.LocalRectZoom.prototype = Object.extend(new WUI.ImageView.Tools.Rect(), {
  getId   : function() {return 'LocalRectZoom';},
  callback: function(param) {
    this.zoomRect(param, this.toolParam.stepZoomRect);
  }
});



WUI.ImageView.UserTools = Class.create();
WUI.ImageView.UserTools.prototype = {
  initialize: function(area) {
    this.param = area.toolParam;
    this.area  = area;
    this.btn   = new Object();
    this._createBotton(area.parent);
  },
  _createBotton: function(obj) {
    var dir = this.area.option.imgdir;
    var x = 6;
    var span = 32;
    var style = {
        top:      '6px',
        position: 'absolute',
        cursor  : 'pointer',
        filter  : 'alpha(opacity=100)'
/* ↑filter
この指定は何の意味もないが、IE6.0への対応
なぜか半透明レイアが存在すると画像表示が高速になる。
opacityはfirefox,safari向けで、こちらの指定は速度に殆ど関係しない。
        opacity : '1.00'*/
    };
    if (this.param.zoomIn) {
      style.left = x + "px";
      x += span;
      var img = Html.create(
          new Html.Data.Image("", dir + "/zoom_in.png", "拡大", style));
      Event.observe(img, 'mousedown', this.zoomInHandler.bind(this), false);
      $(obj).appendChild(img);
      this.btn['zoom_in'] = img;
    }
    if (this.param.zoomOut) {
      style.left = x + "px";
      x += span;
      var img = Html.create(
          new Html.Data.Image("", dir + "/zoom_out.png", "縮小", style));
      Event.observe(img, 'mousedown', this.zoomOutHandler.bind(this), false);
      $(obj).appendChild(img);      
      this.btn['zoom_out'] = img;
    }
    if (this.param.zoomRect) {
      style.left = x + "px";
      x += span;
      var img = Html.create(
          new Html.Data.Image("", dir + "/zoom_rect.png", "矩形範囲を指定して拡大", style));
      Event.observe(img, 'mousedown', this.zoomRectHandler.bind(this), false);
      $(obj).appendChild(img);      
      this.btn['zoom_rect'] = img;
    }
    if (this.param.zoomAll) {
      style.left = x + "px";
      x += span;
      var img = Html.create(
          new Html.Data.Image("", dir + "/zoom_all.png", "全体を表示", style));
      Event.observe(img, 'mousedown', this.zoomAllHandler.bind(this), false);
      $(obj).appendChild(img);      
      this.btn['zoom_all'] = img;
    }
  },
  setBottonImage: function(btn, on) {
    if (!btn) {
        for (b in this.btn) {
            this.setBottonImage(b, on);
        }
    }
    var obj = this.btn[btn];
    if (!obj) return;
    if (on) {
      obj.src = obj.src.replace(btn + ".png", btn + "_d.png");
    } else {
      obj.src = obj.src.replace(btn + "_d.png", btn + ".png");
    }
  },
  zoomInHandler: function(e) {
    this.setBottonImage('zoom_in', true);
    this.area.zoom(this.param.ratioZoomIn, this.param.stepZoomIn);
    Event.stop(e);
  },
  zoomOutHandler: function(e) {
    this.setBottonImage('zoom_out', true);
    this.area.zoom(this.param.ratioZoomOut, this.param.stepZoomOut);
    Event.stop(e);
  },
  zoomRectHandler: function(e) {
    this.setBottonImage('zoom_rect', true);
    this.area.setTool('zoom', this.zoomRectExitHandler.bind(this));
    Event.stop(e);
  },
  zoomRectExitHandler: function(param) {
    this.area.zoomRect(param, this.param.stepZoomRect);
    this.area.setTool('move');
  },
  zoomAllHandler: function(e) {
    this.setBottonImage('zoom_all', true);
    this.area.zoomAll(this.param.stepZoomAll);
    Event.stop(e);
  }
};
