/**
 * GUI[0.9.0]
 * (c) 2007 Shigehito funaki <funaki@sourceforge.jp>
 */
//LogConfig.add({category: 'com.gui', level: LOG_LEVEL.DEBUG});
WUI = new Object();
WUI.logger = LoggerFactory.create("com.gui");

//------------------------------------------------------------------------------
WUI.Event = {
  find: function(event, id) {
    var element = Event.element(event);
    while (element.parentNode && (!element.tagName || (element.id != id)))
      element = element.parentNode;
    return element;
  },

  layerX: function(event, id) {
    var x = (event.offsetX || event.layerX);
    if (id) {
      var cnt = 0;
      var obj = Event.element(event);
      while (obj && obj.id != id && cnt++ < 10) {
        x += Event.element(event).offsetLeft;
        obj = obj.parentNode;
      }
    }
    return x;
  },

  layerY: function(event, id) {
    var y = (event.offsetY || event.layerY);
    if (id) {
      var cnt = 0;
      var obj = Event.element(event);
      while (obj && obj.id != id && cnt++ < 10) {
        y += Event.element(event).offsetTop;
        obj = obj.parentNode;
      }
    }
    return y;
  }
};



WUI.Cue = Class.create();
Object.extend(WUI.Cue.prototype, {
  initialize: function(userObject) {
    this.prev  = null;
    this.next  = null;
    this.first = true;
    this.end   = true;
    this.obj   = userObject;
  },
  getFirst: function() {
    return (!this.first && this.prev) ? this.prev.getFirst() : this;
  },
  getLast: function() {
    return (!this.end   && this.next) ? this.next.getLast() : this;
  },
  addTail: function(cue) {
    var target = this.getLast();

    target.next = cue;
    target.end  = false;
    cue.prev    = target;
    cue.first   = false;
  },
  removeHead: function() {
    var target = this.getFirst();
    if (target && target.next) {
      target.next.first = true;
      target.next.prev  = null;
      return target.next;
    }
    return null;
  }
});


//------------------------------------------------------------------------------
WUI.Util = {
  getElementX: function(obj) {
    if (obj) return this.getPixel(Element.getStyle(obj, 'left'));
  },
  getElementY: function(obj) {
    if (obj) return this.getPixel(Element.getStyle(obj, 'top'));
  },

  getElementWidth: function(obj) {
    if (obj) return this.getPixel(Element.getStyle(obj, 'width'));
  },
  getElementHeight: function(obj) {
    if (obj) return this.getPixel(Element.getStyle(obj, 'height'));
  },
  
  getPixel: function(text) {
    if (text && text.length > 2) {
      return new Number(text.substring(0, text.length - 2));
    }
  },
  
  setPosition: function(obj, x, y) {
//WUI.logger.debug("setPosition[" + obj + "] x:" + x + " y:" + y);
    if (isNaN(x) || isNaN(y)) return;  
    if (obj) Element.setStyle(obj, {top: y + "px", left: x + "px"});
  },
  
  setSize: function(obj, w, h) {
//WUI.logger.debug("setSize[" + obj + "] w:" + w + " h:" + h);
    if (isNaN(w) || isNaN(h)) return;  
    if (obj) Element.setStyle(obj, {width: w + "px", height: h + "px"});
  },
  
  setRect: function(obj, x, y, w, h) {
//WUI.logger.debug("setRect[" + obj + "] x:" + x + " y:" + y + " w:" + w + " h:" + h);
    if (isNaN(x) || isNaN(y) || isNaN(w) || isNaN(h)) return;  
    if (obj) {
      Element.setStyle(obj, {
          top   : y + "px",
          left  : x + "px",
          width : w + "px",
          height: h + "px"
        });
    }
  }
};

//------------------------------------------------------------------------------
WUI.windowToolKit = new Object();
WUI.windowToolKit.windowList          = new Array();
WUI.windowToolKit.eventManagerCache   = new Array();
WUI.windowToolKit.eventManagerCurrent = null;
WUI.windowToolKit.eventManager = function(obj, target, moveArea, resizeArea) {
  this.obj			= obj;
  this.top			= target;
  this.borderColor	= Element.getStyle(target, 'borderColor');
  this.setEventHandler(document, moveArea, resizeArea);
    
  WUI.logger.debug("WUI.windowToolKit.dragger add dragger:" + moveArea.id);
    
  var winCount = WUI.windowToolKit.windowList.length;
//	target.zIndex = winCount + 1;܂삵Ȃ
  WUI.windowToolKit.windowList[winCount] = target;
  WUI.windowToolKit.eventManagerCache[moveArea.id]   = this;
  WUI.windowToolKit.eventManagerCache[resizeArea.id] = this;
};
WUI.windowToolKit.eventManager.prototype = {
  sx : 0,
  sy : 0,
  wx : 0,
  wy : 0,
  ww : 0,
  wh : 0,
  dragging : false,
  resizing : false,
  reset : function() {
    this.dragging	= false;
    this.resizing	= false;
  },
  getX : function() {
    var x = Element.getStyle(this.top, 'left');
    return new Number(x.substring(0, x.length - 2));
  },
  getY : function() {
    var y = Element.getStyle(this.top, 'top');
    return new Number(y.substring(0, y.length - 2));
  },
  getWidth : function() {
    var w = Element.getStyle(this.top, 'width');
   return new Number(w.substring(0, w.length - 2));
  },
  getHeight : function() {
    var h = Element.getStyle(this.top, 'height');
    return new Number(h.substring(0, h.length - 2));
  },
  dragAreaClicked : function(e) {
    var elementId = Event.element(e).id;
    WUI.logger.debug("WUI.windowToolKit.eventManager dragAreaClicked:" + elementId);
    var em = WUI.windowToolKit.eventManagerCache[elementId];
    if (!em) return;
    
    em.sx = Event.pointerX(e);
    em.sy = Event.pointerY(e);
    em.wx = em.getX();
    em.wy = em.getY();
    em.dragging = true;
    em.resizing = false;
    WUI.windowToolKit.eventManagerCurrent = em;
    Element.setStyle(em.top, {borderColor: 'red'});
		
//		em.front();	܂삵Ȃ
  },
  resizeAreaClicked : function(e) {
    var elementId = Event.element(e).id;
    WUI.logger.debug("WUI.windowToolKit.eventManager resizeAreaClicked:" + elementId);
    var em = WUI.windowToolKit.eventManagerCache[elementId];
    if (!em) return;
    
    em.sx = Event.pointerX(e);
    em.sy = Event.pointerY(e);
    em.wx = em.getX();
    em.wy = em.getY();
    em.ww = em.getWidth();
    em.wh = em.getHeight();
    em.dragging = false;
    em.resizing = true;
    WUI.windowToolKit.eventManagerCurrent = em;
    Element.setStyle(em.top, {borderColor: 'red'});
  },
  mousemove : function(e) {
    var em = WUI.windowToolKit.eventManagerCurrent;
    if (!em) return;
    
    var x = Event.pointerX(e) - em.sx;
    var y = Event.pointerY(e) - em.sy;
    if (em.dragging) {
      Event.stop(e);//ffoxɂăhbNɃeLXgIĂ܂̂}~B
      var mx = em.wx + x;
      var my = em.wy + y;
      Element.setStyle(em.top, {top: my + 'px', left: mx + 'px'});
    } else if (em.resizing) {
      Event.stop(e);//ffoxɂăhbNɃeLXgIĂ܂̂}~B
      var w = em.ww + x;
      var h = em.wh + y;
      if (w < em.obj.param.minWidth)  w = em.obj.param.minWidth;
      if (h < em.obj.param.minHeight) h = em.obj.param.minHeight;
      Element.setStyle(em.top, {width: w + 'px',height: h + 'px'});
      em.obj.resize(w, h);
    }
  },
  mouseup : function(e) {
    var em = WUI.windowToolKit.eventManagerCurrent;
    if (!em) return;
    WUI.windowToolKit.eventManagerCurrent = null;
    em.reset();
    Element.setStyle(em.top, {borderColor: em.borderColor});
  },
  setEventHandler : function(view, moveArea, resizeArea) {
    Event.observe(view,       'mouseup',   this.mouseup, true);
    Event.observe(view,       'mousemove', this.mousemove, true);
    Event.observe(moveArea,   'mousedown', this.dragAreaClicked, true);
    if (resizeArea) {
	  Event.observe(resizeArea, 'mousedown', this.resizeAreaClicked, true);
    }
  },
  front : function() {
    var max		= 1; 
    var top		= null;
    for (var i = 0; i < WUI.windowToolKit.windowList.length; i++) {
      var w = WUI.windowToolKit.windowList[i];
      if (w.id == this.obj.top.id) {
        top = w;
      }
      var idx = w.zIndex;
      if (max < idx) {
        max = idx;
      }
    }
    if (top) {
      for (var i = 0; i < WUI.windowToolKit.windowList.length; i++) {
       	var w = WUI.windowToolKit.windowList[i];
        if (w.zIndex > top.zIndex) {
          w.zIndex = w.zIndex - 1;
        }
      }
      top.zIndex = max;
    }
  }
};



//------------------------------------------------------------------------------
WUI.Dialog = function(id, name, param) {
  var p = WUI.model.dialog;
  Html.override(p, param);
  p.title.name = name;
  this.create(this, id, p);
};
/**
 * _CAO𐶐ĕԂBԂIuWFNg̓{fBdivłB
 */
WUI.Dialog.prototype.create = function(dialogObj, id, param) {
  WUI.logger.debug("GUI#createDialog param=" + Layout.dump(param));	
	
  //\z---------------------------------------------------
  this.param = param;
  var id_h = id + "_h";
  var id_b = id + "_b";
  var id_f = id + "_f";
  var d  = Html.create(new Html.Data.Div(id, {
    style     : param.style
    }));
  var d1 = Html.create(new Html.Data.Div(id_h, {
    text      : param.title.name,
    attribute : param.title.attribute,
    style     : param.title.style
    }));
  var d2 = Html.create(new Html.Data.Div(id_b, {
    	style     : param.body.style
    	}));
  var d3 =  Html.create(new Html.Data.Div(id_f, {
    attribute : param.buttomBar.attribute,
    style     : param.buttomBar.style
    }));

  //X^Cݒ-----------------------------------------------
  d1.style.height = (param.title.height - param.title.padding * 2) + 'px';
  d2.style.height = (param.height
      - param.body.padding * 2
      - param.title.height - param.buttomBar.height
      ) + 'px';
  d3.style.height = (param.buttomBar.height - param.buttomBar.padding * 2) + 'px';
  d1.style.padding = param.title.padding     + 'px';
  d2.style.padding = param.body.padding      + 'px';
  d3.style.padding = param.buttomBar.padding + 'px';
  Element.setStyle(d, {
      position : 'absolute',  /*  relative  absolute@̓P[Xɂ̂œKXύXv */
      top      : param.top  + 'px',
      left     : param.left + 'px',
      width    : param.width  + 'px',
      height   : param.height + 'px'
      });

  d.appendChild(d1);
  d.appendChild(d2);
  d.appendChild(d3);

  //dailogIuWFNgɕϐݒ-----------------------------------
  dialogObj.top   = d;
  dialogObj.title = d1;
  dialogObj.body  = d2;

  dialogObj.eventManager = new WUI.windowToolKit.eventManager(this, d, d1, d3);
};
WUI.Dialog.prototype.resize = function(width, height) {
  this.body.style.height = (
      height
      - this.param.body.padding * 2
      - this.param.title.height - this.param.buttomBar.height
      ) + 'px';
}


//------------------------------------------------------------------------------
WUI.model = {
  dialog : {
    id         : 'noName',
    width      : 320,
    height     : 200,
    resize     : true,
    top        : 0,
    left       : 0,
    minWidth   : 100,
    minHeight  : 100,
    style      : {
      borderStyle	: "solid",
      borderWidth	: "1px",
      borderColor	: "#333333"
    },
    title      : {
      name       : 'noName',
      height     : 22,
      padding    : 0,
      style      : {
        color           : '#333333',
        backgroundColor : '#0099EE',
        fontSize		: '12pt',
        borderStyle		: "solid",
        borderWidth		: "0px",
        borderColor		: "#333333"
      }
    },
    body       : {
      padding    : 0,
      style      : {
        backgroundColor : '#F0F0F0',
        borderStyle		: "solid",
        borderWidth		: "0px",
        borderColor		: "#333333"
      }
    },
    buttomBar  : {
      height     : 22,
      padding    : 0,
      style      : {
        color           : '#333333',
        backgroundColor : '#aaaaaa',
        fontSize		: '12pt',
        borderStyle		: "solid",
        borderWidth		: "0px",
        borderColor		: "#333333"
      }
    }
  }
};
