/**
 * table[0.9.1]
 * (c) 2007 Shigehito funaki <funaki@sourceforge.jp>
 */
LogConfig.add({category: 'com.gui.table', level: LOG_LEVEL.DEBUG});

WUI.Table = new Object();
WUI.Table.logger = LoggerFactory.create("com.gui.table");

//------------------------------------------------------------------------------
// C[Wr[̃[U[fBnewĂB
WUI.Table.ListBox = Class.create();
WUI.Table.ListBox.prototype = {
  initialize: function(divObj, id, option) {
    WUI.Table.logger.debug("WUI.Table#initialize");

    this.parent  = divObj;
    this.id      = id;
    this.divObj  = null;
    this.bodyObj = null;
    this.option  = Object.extend({
            imgdir: '../img'
        }, option);
    this.state = {
         currentItem: null
    };
    this.data = new Array();
 
    //X^C
    this.style = {
      tr: {
      	color           : '#333333',
      	backgroundColor : '#f0f0f0'
      },
      trActive: {
      	color           : '#ffffff',
      	backgroundColor : '#0000cc'
      },
      td: {
        fontFamily      : "lr SVbN",
      	fontSize        : '11pt',
        margin          : '0px 0px 0px 0px',
      	padding         : '3px 4px 2px 6px',
        borderWidth     : '0px 0px 1px 0px',
        borderStyle     : 'solid',
        borderColor     : '#fefefe',
        cursor          : 'default' /*pointer*/
      }
    };/*	border				: 1px solid #666666*/
 
    this._createElement(this.option);
  },

  _createElement: function(option) {
    var divId = this.id + "_div";
    
    //tablediv
    var opt = {style: {overflow: 'auto'}};
    if (option.width)  opt.style.width  = option.width;
    if (option.height) opt.style.height = option.height;
    var div = new Html.Data.Div(divId, opt);
    this.divObj = Html.create(div);
    
    var tableData = new Html.Data();
    tableData.tag       = 'table';
    tableData.attribute = {width: '100%'};
    tableData.style     = {borderCollapse: 'collapse'};
    var table = Html.create(tableData);
    
    var tbodyData = new Html.Data();
    tableData.tag       = 'tbody';
    this.bodyObj = Html.create(tableData);

    //
    table.appendChild(this.bodyObj);
    this.divObj.appendChild(table);
    this.parent.appendChild(this.divObj);
  },
  
  addItem: function(key, text) {
    var tr = Html.create(new Html.Data.Tr({style: this.style.tr}));
    var td = Html.create(new Html.Data.Td({text: text, style: this.style.td}));

    this.data[key] = new WUI.Table.ListBox.Item(this, tr, key);

    tr.appendChild(td);
    this.bodyObj.appendChild(tr);
  },
  
  clicked: function(item) {return true;},	//I[o[Chė~
  
  getSelectedItem: function() {
  	return this.state.currentItem;
  },
  getSelectedKey: function() {
  	var item = this.getSelectedItem();
  	return (item) ? item.key : "";
  },
  setSelectedItem: function(item) {
      
      
  },
  setSelectedKey: function(key) {
  	var state = this.state;
    this.data.each(function(rec) {
      if (!rec) return;
      if (rec.key == key) {
        if (state.currentItem) state.currentItem.setSelected(false);
        state.currentItem = rec;
        rec.setSelected(true);
        rec.eventTarget.scrollIntoView();
      }
    });
  },

  
  removeAll: function() {
  	var bodyObj = this.bodyObj;
    this.data.each(function(rec) {
      if (!rec) return;
      rec.unload();
      bodyObj.removeChild(rec.eventTarget);
    });
    this.data = new Array();
  },

  remove: function(target) {
    if (!target) return;
    
    if (this.state.currentItem.equals(target)) {
      this.state.currentItem = null;
    }
    target.unload();
    this.bodyObj.removeChild(target.eventTarget);
    //f[^z񂩂폜
    var newData = new Array();
    for (var key in this.data) {
      var dt = this.data[key];
      if (key == target.key) continue;
      newData[key] = dt;
    }
    this.data = newData;
  },
  
  /** falseԂƑILZ */
  _click: function(e, item) {
    if (this.state.currentItem) this.state.currentItem.setSelected(false);
  	this.state.currentItem = item;
    return this.clicked(item);
  }
};

WUI.Table.ListBox.Item = Class.create();
WUI.Table.ListBox.Item.prototype = {
  initialize: function(listBox, eventTarget, key) {
    this.listBox     = listBox;
    this.eventTarget = eventTarget;
    this.key         = key;
    Event.observe(eventTarget, 'mousedown', this._mouseDown.bind(this), true);
  },
  _mouseDown: function(e) {
  	if (!this.listBox._click(e, this)) return false;
    this.setSelected(true);
  },
  unload: function() {
    Event.stopObserving(this.eventTarget, 'mousedown', this._mouseDown, true);
  },
  setSelected: function(active) {
    var style = (active) ? this.listBox.style.trActive : this.listBox.style.tr;
    Element.setStyle(this.eventTarget, style);
  },
  equals: function(target) {
    return (target.key == this.key);
  }
};
