/*
  liboftp: this is an FTP library to simplify the work to a Developer
  who want to work with FTP servers (RFC 959).

  Copyright (c) 2009 hirohito higashi. All rights reserved.
  This file is distributed under BSD license.
*/


/***** Feature test switches ************************************************/
/***** System headers *******************************************************/
#include <unistd.h>


/***** Local headers ********************************************************/
#include "liboftp.h"
#include "sub.h"


/***** Constat values *******************************************************/
/***** Macros ***************************************************************/
/***** Typedefs *************************************************************/
/***** Function prototypes **************************************************/
/***** Local variables ******************************************************/
/***** Global variables *****************************************************/
/***** Signal catching functions ********************************************/
/***** Local functions ******************************************************/
/***** Global functions *****************************************************/

/****************************************************************************/
/*! ファイル送信用デスクリプタ生成
 *
 *@param	ftp	LIBOFTPへのポインタ。
 *@param	fname	サーバ上のファイル名
 *@retval	int	デスクリプタ。マイナス値ならエラーコード
 *@note
 */
int ftp_put_descriptor( LIBOFTP *ftp, const char *fname )
{
    int data_socket;

    if( ftp->flag_passive ) {
	data_socket = ftp_getready_pasv( ftp, "STOR", fname );
    } else {
	data_socket = ftp_getready_active( ftp, "STOR", fname );
    }
    return data_socket;
}



/****************************************************************************/
/*! ファイル送信用デスクリプタ生成 アペンドモード
 *
 *@param	ftp	LIBOFTPへのポインタ。
 *@param	fname	サーバ上のファイル名
 *@retval	int	デスクリプタ。マイナス値ならエラーコード
 *@note
 */
int ftp_append_descriptor( LIBOFTP *ftp, const char *fname )
{
    int data_socket;

    if( ftp->flag_passive ) {
	data_socket = ftp_getready_pasv( ftp, "APPE", fname );
    } else {
	data_socket = ftp_getready_active( ftp, "APPE", fname );
    }
    return data_socket;
}



/****************************************************************************/
/*! ファイル送信用デスクリプタクローズ
 *
 *@param	ftp	LIBOFTPへのポインタ。
 *@param	desc	デスクリプタ
 *@retval	int	エラーコード
 *@note
 */
int ftp_put_descriptor_close( LIBOFTP *ftp, int desc )
{
    int res;

    /*
     * close socket.
     */
    close( desc );

    /*
     * receive response.
     */
    res = ftp_receive_response( ftp, ftp->error_message, sizeof(ftp->error_message)-1 );
    if( res != 226 ) {						/* 226: Closing data connection. */
	DEBUGPRINT1( "got illegal response %d\n", res );
	return res < 0? res: LIBOFTP_ERROR_PROTOCOL;
    }

    return LIBOFTP_NOERROR;
}



/****************************************************************************/
/*! ファイル送信用デスクリプタクローズ アペンドモード
 *
 *@param	ftp	LIBOFTPへのポインタ。
 *@param	desc	デスクリプタ
 *@retval	int	エラーコード
 *@note
 */
int ftp_append_descriptor_close( LIBOFTP *ftp, int desc )
{
    return ftp_put_descriptor_close( ftp, desc );
}
