/*
  liboftp: this is an FTP library to simplify the work to a Developer
  who want to work with FTP servers (RFC 959).

  Copyright (c) 2009 hirohito higashi. All rights reserved.
  This file is distributed under BSD license.
*/


/***** Feature test switches ************************************************/
/***** System headers *******************************************************/
#include <stdio.h>


/***** Local headers ********************************************************/
#include "liboftp.h"
#include "sub.h"


/***** Constat values *******************************************************/
/***** Macros ***************************************************************/
/***** Typedefs *************************************************************/
/***** Function prototypes **************************************************/
/***** Local variables ******************************************************/
/***** Global variables *****************************************************/
/***** Signal catching functions ********************************************/
/***** Local functions ******************************************************/
/***** Global functions *****************************************************/

/****************************************************************************/
/*! SITEコマンド
 *
 *@param	ftp	LIBOFTPへのポインタ。
 *@param	cmdline	コマンドライン
 *@retval	int	エラーコード
 *@note
 */
int ftp_site( LIBOFTP *ftp, const char *cmdline )
{
    char str1[512];
    int res;

    /*
     * send SITE command
     */
    snprintf( str1, sizeof(str1)-1, "SITE %s\r\n", cmdline );
    if( ftp_send_command( ftp, str1 ) < 0 ) {
	DEBUGPRINT1( "site: command sending error. %s\n", str1 );
	return LIBOFTP_ERROR_OS;
    }

    res = ftp_receive_response( ftp, ftp->error_message, sizeof(ftp->error_message)-1 );
    if( res != 200 ) {						/* 200: Command okay. */
	DEBUGPRINT1( "command response error. %d\n", res );
	return res < 0? res: LIBOFTP_ERROR_PROTOCOL;
    }

    return LIBOFTP_NOERROR;
}
