/*
  liboftp: this is an FTP library to simplify the work to a Developer
  who want to work with FTP servers (RFC 959).

  Copyright (c) 2009 hirohito higashi. All rights reserved.
  This file is distributed under BSD license.
*/


/***** Feature test switches ************************************************/
/***** System headers *******************************************************/
#include <unistd.h>


/***** Local headers ********************************************************/
#include "liboftp.h"
#include "sub.h"


/***** Constat values *******************************************************/
/***** Macros ***************************************************************/
/***** Typedefs *************************************************************/
/***** Function prototypes **************************************************/
/***** Local variables ******************************************************/
/***** Global variables *****************************************************/
/***** Signal catching functions ********************************************/
/***** Local functions ******************************************************/
/***** Global functions *****************************************************/

/****************************************************************************/
/*! QUITコマンド
 *
 *@param	ftp	LIBOFTPへのポインタ。
 *@retval	int	エラーコード
 *@note
 */
int ftp_quit( LIBOFTP *ftp )
{
    char str1[] = "QUIT\r\n";
    int res;

    /*
     * send QUIT command
     */
    if( ftp_send_command( ftp, str1 ) < 0 ) {
	DEBUGPRINT1( "command sending error. %s\n", str1 );
	res = LIBOFTP_ERROR_OS;
	goto CLOSE;
    }

    res = ftp_receive_response( ftp, ftp->error_message, sizeof(ftp->error_message)-1 );
    if( res == 221 ) {						/* 221: Service closing control connection. */
	res = LIBOFTP_NOERROR;
    } else {
	DEBUGPRINT1( "command response error. %d\n", res );
	if( res >= 0 ) res = LIBOFTP_ERROR_PROTOCOL;
    }

    /*
     * close socket.
     */
CLOSE:
    close( ftp->socket );
    ftp->socket = 0;

    return res;
}
