/*
  liboftp: this is an FTP library to simplify the work to a Developer
  who want to work with FTP servers (RFC 959).

  Copyright (c) 2009 hirohito higashi. All rights reserved.
  This file is distributed under BSD license.
*/


/***** Feature test switches ************************************************/
/***** System headers *******************************************************/
#include <stdio.h>
#include <string.h>



/***** Local headers ********************************************************/
#include "liboftp.h"
#include "sub.h"


/***** Constat values *******************************************************/
/***** Macros ***************************************************************/
/***** Typedefs *************************************************************/
/***** Function prototypes **************************************************/
/***** Local variables ******************************************************/
/***** Global variables *****************************************************/
/***** Signal catching functions ********************************************/
/***** Local functions ******************************************************/
/***** Global functions *****************************************************/

/****************************************************************************/
/*! タイプコマンド
 *
 *@param	ftp	LIBOFTPへのポインタ。
 *@param	type	{ascii|binary|image}
 *@retval	int	エラーコード
 *@note
 * FTPのTYPEコマンドを発行するだけで、データ転送は常に無変換で行う。
 * CR => CRLF 変換などは、必要ならユーザ側で行う。
 */
int ftp_type( LIBOFTP *ftp, const char *type )
{
    char str1[256];
    int res;

    if( strcmp( type, "ascii" ) == 0 ) {
	snprintf( str1, sizeof(str1)-1, "TYPE A\r\n" );
	ftp->data_type = ASCII;
	
    } else if( strcmp( type, "binary" ) == 0 ) {
	snprintf( str1, sizeof(str1)-1, "TYPE I\r\n" );
	ftp->data_type = IMAGE;
	
    } else if( strcmp( type, "image" ) == 0 ) {
	snprintf( str1, sizeof(str1)-1, "TYPE I\r\n" );
	ftp->data_type = IMAGE;
	
    } else {
	DEBUGPRINT1( "argument error. %s\n", type );
	strncpy( ftp->error_message, "argument error.", sizeof(ftp->error_message) );
	return LIBOFTP_ERROR;
    }
    
    /*
     * send TYPE command
     */
    if( ftp_send_command( ftp, str1 ) < 0 ) {
	DEBUGPRINT1( "command sending error. %s\n", str1 );
	return LIBOFTP_ERROR_OS;
    }

    res = ftp_receive_response( ftp, ftp->error_message, sizeof(ftp->error_message)-1 );
    if( res != 200 ) {						/* 200: Command okay. */
	DEBUGPRINT1( "command response error. %d\n", res );
	return res < 0? res: LIBOFTP_ERROR_PROTOCOL;
    }

    return LIBOFTP_NOERROR;
}
