/*
  liboftp: this is an FTP library to simplify the work to a Developer
  who want to work with FTP servers (RFC 959).

  Copyright (c) 2009 hirohito higashi. All rights reserved.
  This file is distributed under BSD license.
*/


/***** Feature test switches ************************************************/
/***** System headers *******************************************************/
#include <stdio.h>
#include <string.h>


/***** Local headers ********************************************************/
#include "liboftp.h"
#include "sub.h"


/***** Constat values *******************************************************/
/***** Macros ***************************************************************/
/***** Typedefs *************************************************************/
/***** Function prototypes **************************************************/
/***** Local variables ******************************************************/
/***** Global variables *****************************************************/
/***** Signal catching functions ********************************************/
/***** Local functions ******************************************************/
/***** Global functions *****************************************************/

/****************************************************************************/
/*! ユーザ認証
 *
 *@param	ftp	LIBOFTPへのポインタ。
 *@param	user	ユーザ名
 *@param	pass	パスワード
 *@retval	int	エラーコード
 *@note
 * 認証後、定型的なコマンドも送信する。
 */
int ftp_user( LIBOFTP *ftp, const char *user, const char *pass )
{
    char str1[256];
    int res;

    /*
     * send user name.
     */
    snprintf( str1, sizeof(str1)-1, "USER %s\r\n", user );
    if( ftp_send_command( ftp, str1 ) < 0 ) {
	DEBUGPRINT1( "user command sending error.%s\n", "" );
	return LIBOFTP_ERROR_OS;
    }

    res = ftp_receive_response( ftp, ftp->error_message, sizeof(ftp->error_message) );
    if( res == 230 ) {						/* 230: User logged in, proceed. */
	goto PROCEED;
    }
    if( res != 331 ) {						/* 331: User name okay, need password. */
	DEBUGPRINT1( "USER command response error. %d\n", res );
	return res < 0? res: LIBOFTP_ERROR_PROTOCOL;
    }

    /*
     * send password.
     */
    snprintf( str1, sizeof(str1)-1, "PASS %s\r\n", pass );
    if( ftp_send_command( ftp, str1 ) < 0 ) {
	DEBUGPRINT1( "pass command sending error.%s\n", "" );
	return LIBOFTP_ERROR_OS;
    }
    
    res = ftp_receive_response( ftp, ftp->error_message, sizeof(ftp->error_message) );
    if( res != 230 ) {						/* 230: User logged in, proceed. */
	DEBUGPRINT1( "user authentication error.%s\n", "" );
	return res < 0? res: LIBOFTP_ERROR_PROTOCOL;
    }

PROCEED:
    /*
     * system type.
     */
    snprintf( str1, sizeof(str1)-1, "SYST\r\n" );
    if( ftp_send_command( ftp, str1 ) < 0 ) {
	DEBUGPRINT1( "SYST command sending error.%s\n", "" );
	return LIBOFTP_ERROR_OS;
    }

    res = ftp_receive_response( ftp, str1, sizeof(str1) );
    if( res == 215 ) {
	if( strstr( str1, "UNIX" ) != 0 ) {
	    ftp->system_type = UNIX;
	} else if( strstr( str1, "Windows_NT" ) != 0 ) {
	    ftp->system_type = Windows_NT;
	}
	DEBUGPRINT1( "system type is %d\n", ftp->system_type );
    }

    return LIBOFTP_NOERROR;
}
    

