/*
  liboftp: this is an FTP library to simplify the work to a Developer
  who want to work with FTP servers (RFC 959).

  Copyright (c) 2009 hirohito higashi. All rights reserved.
  This file is distributed under BSD license.
*/


/***** Feature test switches ************************************************/
/***** System headers *******************************************************/
#include <string.h>


/***** Local headers ********************************************************/
#include "liboftp.h"
#include "sub.h"


/***** Constat values *******************************************************/
/***** Macros ***************************************************************/
/***** Typedefs *************************************************************/
/***** Function prototypes **************************************************/
/***** Local variables ******************************************************/
/***** Global variables *****************************************************/
/***** Signal catching functions ********************************************/
/***** Local functions ******************************************************/
/***** Global functions *****************************************************/

/****************************************************************************/
/*! PWDコマンド
 *
 *@param	ftp	LIBOFTPへのポインタ。
 *@param	buf	結果代入先バッファ
 *@param	bufsiz	バッファサイズ
 *@retval	int	エラーコード
 *@note
 */
int ftp_pwd( LIBOFTP *ftp, char *buf, int bufsiz )
{
    char str1[512] = "PWD\r\n";
    int res;
    char *p1, *p2;

    if( ftp->socket < 0 ) return LIBOFTP_ERROR;

    /*
     * send PWD command
     */
    if( ftp_send_command( ftp, str1 ) < 0 ) {
	DEBUGPRINT1( "command sending error. %s\n", str1 );
	return LIBOFTP_ERROR_OS;
    }

    if( (res = ftp_receive_response( ftp, str1, sizeof(str1) )) != 257 ) {	/* 257: "PATHNAME" created. */
	DEBUGPRINT1( "command response error. %d\n", res );
	strncpy( ftp->error_message, str1, sizeof(ftp->error_message) - 1 );
	return res < 0? res: LIBOFTP_ERROR_PROTOCOL;
    }

    /*
     * parse response
     */
    p1 = strchr( str1, '"' );
    if( p1 == NULL ) {
	DEBUGPRINT1( "reply string parse error. %s\n", str1 );
	strncpy( ftp->error_message, "reply string parse error.", sizeof( ftp->error_message ) );
	return LIBOFTP_ERROR_PROTOCOL;
    }

    p2 = strchr( p1+1, '"' );
    if( p2 == NULL ) {
	DEBUGPRINT1( "reply string parse error. %s\n", str1 );
	strncpy( ftp->error_message, "reply string parse error.", sizeof( ftp->error_message ) );
	return LIBOFTP_ERROR_PROTOCOL;
    }
    if( bufsiz < (p2-p1) ) {
	DEBUGPRINT1( "buffer too small.%s", "" );
	strncpy( ftp->error_message, "buffer too small", sizeof( ftp->error_message ) );
	return LIBOFTP_ERROR_BUFFER;
    }

    memcpy( buf, p1+1, p2 - p1 - 1 );
    buf[ p2 - p1 - 1 ] = 0;

    return LIBOFTP_NOERROR;
}
